/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExchange
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpExchange.class);
    private final AutoLock lock = new AutoLock();
    private final HttpDestination destination;
    private final HttpRequest request;
    private final ResponseListeners listeners;
    private final HttpResponse response;
    private State requestState = State.PENDING;
    private State responseState = State.PENDING;
    private HttpChannel _channel;
    private Throwable requestFailure;
    private Throwable responseFailure;

    public HttpExchange(HttpDestination destination, HttpRequest request) {
        this(destination, request, request.getResponseListeners());
    }

    public HttpExchange(HttpDestination destination, HttpRequest request, ResponseListeners listeners) {
        this.destination = destination;
        this.request = request;
        this.listeners = listeners;
        this.response = new HttpResponse(request);
        HttpConversation conversation = request.getConversation();
        conversation.getExchanges().offer(this);
        conversation.updateResponseListeners(null);
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    public HttpConversation getConversation() {
        return this.request.getConversation();
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public Throwable getRequestFailure() {
        try (AutoLock l = this.lock.lock();){
            Throwable throwable = this.requestFailure;
            return throwable;
        }
    }

    public ResponseListeners getResponseListeners() {
        return this.listeners;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Throwable getResponseFailure() {
        try (AutoLock l = this.lock.lock();){
            Throwable throwable = this.responseFailure;
            return throwable;
        }
    }

    @Override
    public long getExpireNanoTime() {
        return this.request.getTimeoutNanoTime();
    }

    boolean associate(HttpChannel channel) {
        boolean result = false;
        boolean abort = false;
        try (AutoLock l = this.lock.lock();){
            if (this.requestState == State.PENDING && this.responseState == State.PENDING) {
                boolean bl = abort = this._channel != null;
                if (!abort) {
                    this._channel = channel;
                    result = true;
                }
            }
        }
        if (abort) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
        return result;
    }

    void disassociate(HttpChannel channel) {
        boolean abort = false;
        try (AutoLock l = this.lock.lock();){
            if (this._channel != channel || this.requestState != State.TERMINATED || this.responseState != State.TERMINATED) {
                abort = true;
            }
            this._channel = null;
        }
        if (abort) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
    }

    private HttpChannel getHttpChannel() {
        try (AutoLock l = this.lock.lock();){
            HttpChannel httpChannel = this._channel;
            return httpChannel;
        }
    }

    public boolean requestComplete(Throwable failure) {
        try (AutoLock l = this.lock.lock();){
            boolean bl = this.completeRequest(failure);
            return bl;
        }
    }

    private boolean completeRequest(Throwable failure) {
        if (this.requestState == State.PENDING) {
            this.requestState = State.COMPLETED;
            this.requestFailure = failure;
            return true;
        }
        return false;
    }

    public boolean isResponseComplete() {
        try (AutoLock l = this.lock.lock();){
            boolean bl = this.responseState == State.COMPLETED;
            return bl;
        }
    }

    public boolean responseComplete(Throwable failure) {
        try (AutoLock l = this.lock.lock();){
            boolean bl = this.completeResponse(failure);
            return bl;
        }
    }

    private boolean completeResponse(Throwable failure) {
        if (this.responseState == State.PENDING) {
            this.responseState = State.COMPLETED;
            this.responseFailure = failure;
            return true;
        }
        return false;
    }

    public Result terminateRequest() {
        Result result = null;
        try (AutoLock l = this.lock.lock();){
            if (this.requestState == State.COMPLETED) {
                this.requestState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated request for {}, result: {}", (Object)this, result);
        }
        return result;
    }

    public Result terminateResponse() {
        Result result = null;
        try (AutoLock l = this.lock.lock();){
            if (this.responseState == State.COMPLETED) {
                this.responseState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated response for {}, result: {}", (Object)this, result);
        }
        return result;
    }

    boolean isResponseCompleteOrTerminated() {
        try (AutoLock l = this.lock.lock();){
            boolean bl = this.responseState == State.COMPLETED || this.responseState == State.TERMINATED;
            return bl;
        }
    }

    public void abort(Throwable failure, Promise<Boolean> promise) {
        boolean abortResponse;
        boolean abortRequest;
        try (AutoLock l = this.lock.lock();){
            abortRequest = this.completeRequest(failure);
            abortResponse = this.completeResponse(failure);
        }
        if (!abortRequest && !abortResponse) {
            promise.succeeded(false);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed {}: req={}/rsp={}", new Object[]{this, abortRequest, abortResponse, failure});
        }
        Request.Content body = this.request.getBody();
        if (abortRequest && body != null) {
            body.fail(failure);
        }
        if (this.destination.remove(this)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborting while queued {}", (Object)this, (Object)failure);
            }
            this.notifyFailureComplete(failure);
            promise.succeeded(true);
            return;
        }
        HttpChannel channel = this.getHttpChannel();
        if (channel == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborting before association {}", (Object)this, (Object)failure);
            }
            this.notifyFailureComplete(failure);
            promise.succeeded(true);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Aborting while active {}", (Object)this, (Object)failure);
        }
        channel.abort(this, abortRequest ? failure : null, abortResponse ? failure : null, promise);
    }

    private void notifyFailureComplete(Throwable failure) {
        this.request.notifyFailure(failure);
        ResponseListeners listeners = this.getConversation().getResponseListeners();
        listeners.notifyFailure(this.response, failure);
        listeners.notifyComplete(new Result(this.request, failure, this.response, failure));
    }

    public void resetResponse() {
        try (AutoLock l = this.lock.lock();){
            this.responseState = State.PENDING;
            this.responseFailure = null;
            this.response.clearHeaders();
        }
    }

    public void proceed(Throwable failure) {
        HttpChannel channel = this.getHttpChannel();
        if (channel != null) {
            channel.proceed(this, failure);
        }
    }

    public String toString() {
        try (AutoLock l = this.lock.lock();){
            String string = String.format("%s@%x{req=%s[%s/%s] res=%s[%s/%s]}", new Object[]{HttpExchange.class.getSimpleName(), this.hashCode(), this.request, this.requestState, this.requestFailure, this.response, this.responseState, this.responseFailure});
            return string;
        }
    }

    private static enum State {
        PENDING,
        COMPLETED,
        TERMINATED;

    }
}

