/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.content;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Objects;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.ResourceHttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;

public class ResourceHttpContentFactory
implements HttpContent.Factory {
    private final Resource _baseResource;
    private final MimeTypes _mimeTypes;

    public ResourceHttpContentFactory(Resource baseResource, MimeTypes mimeTypes) {
        Objects.requireNonNull(mimeTypes, "MimeTypes cannot be null");
        this._baseResource = Objects.requireNonNullElse(baseResource, ResourceFactory.root().newResource("."));
        this._mimeTypes = mimeTypes;
    }

    @Override
    public HttpContent getContent(String pathInContext) throws IOException {
        try {
            Resource resource = this.resolve(pathInContext);
            if (Resources.missing(resource)) {
                return null;
            }
            return this.load(pathInContext, resource);
        }
        catch (Throwable t2) {
            InvalidPathException saferException = new InvalidPathException(pathInContext, "Invalid PathInContext");
            saferException.initCause(t2);
            throw saferException;
        }
    }

    protected Resource resolve(String pathInContext) {
        return this._baseResource.resolve(pathInContext);
    }

    private HttpContent load(String pathInContext, Resource resource) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(pathInContext));
    }

    public String toString() {
        return "ResourceContentFactory[" + String.valueOf(this._baseResource) + "]@" + this.hashCode();
    }
}

