/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class ByteChannelContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker _invoker = new SerializedInvoker();
    private final ByteBufferPool.Sized _byteBufferPool;
    private ByteChannel _byteChannel;
    private final long _offset;
    private final long _length;
    private RetainableByteBuffer _buffer;
    private long _totalRead;
    private Runnable demandCallback;
    private Content.Chunk _terminal;

    public ByteChannelContentSource(SeekableByteChannel seekableByteChannel, long offset, long length) {
        this(null, seekableByteChannel, offset, length);
    }

    public ByteChannelContentSource(ByteBufferPool.Sized byteBufferPool, SeekableByteChannel seekableByteChannel, long offset, long length) {
        this(byteBufferPool, (ByteChannel)seekableByteChannel, offset, length);
        if (offset >= 0L && seekableByteChannel != null) {
            try {
                seekableByteChannel.position(offset);
            }
            catch (IOException e) {
                this.lockedSetTerminal(Content.Chunk.from(e, true));
            }
        }
    }

    public ByteChannelContentSource(ByteChannel byteChannel) {
        this(null, byteChannel, -1L, -1L);
    }

    public ByteChannelContentSource(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel) {
        this(byteBufferPool, byteChannel, -1L, -1L);
    }

    private ByteChannelContentSource(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel, long offset, long length) {
        this._byteBufferPool = Objects.requireNonNullElse(byteBufferPool, ByteBufferPool.SIZED_NON_POOLING);
        this._byteChannel = byteChannel;
        this._offset = offset < 0L ? 0L : offset;
        this._length = length;
    }

    protected ByteChannel open() throws IOException {
        return this._byteChannel;
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this._invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            ExceptionUtil.run(demandCallback, this::fail);
        }
    }

    protected void lockedSetTerminal(Content.Chunk terminal) {
        if (this._terminal == null) {
            this._terminal = Objects.requireNonNull(terminal);
        } else {
            ExceptionUtil.addSuppressedIfNotAssociated(this._terminal.getFailure(), terminal.getFailure());
        }
        IO.close(this._byteChannel);
        if (this._buffer != null) {
            this._buffer.release();
        }
        this._buffer = null;
    }

    private void lockedEnsureOpenOrTerminal() {
        if (!(this._terminal != null || this._byteChannel != null && this._byteChannel.isOpen())) {
            try {
                ByteChannel byteChannel;
                this._byteChannel = this.open();
                if (this._byteChannel == null || !this._byteChannel.isOpen()) {
                    this.lockedSetTerminal(Content.Chunk.from(new ClosedChannelException(), true));
                } else if (this._offset >= 0L && (byteChannel = this._byteChannel) instanceof SeekableByteChannel) {
                    SeekableByteChannel seekableByteChannel = (SeekableByteChannel)byteChannel;
                    seekableByteChannel.position(this._offset);
                }
            }
            catch (IOException e) {
                this.lockedSetTerminal(Content.Chunk.from(e, true));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Content.Chunk read() {
        block19: {
            AutoLock ignored = this.lock.lock();
            this.lockedEnsureOpenOrTerminal();
            if (this._terminal != null) {
                Content.Chunk chunk = this._terminal;
                if (ignored == null) return chunk;
                ignored.close();
                return chunk;
            }
            if (this._buffer == null) {
                this._buffer = this._byteBufferPool.acquire();
            } else if (this._buffer.isRetained()) {
                this._buffer.release();
                this._buffer = this._byteBufferPool.acquire();
            }
            try {
                ByteBuffer byteBuffer = this._buffer.getByteBuffer();
                BufferUtil.clearToFill(byteBuffer);
                if (this._length >= 0L) {
                    byteBuffer.limit((int)Math.min((long)this._buffer.capacity(), this._length - this._totalRead));
                }
                int read = this._byteChannel.read(byteBuffer);
                BufferUtil.flipToFlush(byteBuffer, 0);
                if (read == 0) {
                    Content.Chunk chunk = null;
                    if (ignored == null) return chunk;
                    ignored.close();
                    return chunk;
                }
                if (read <= 0) break block19;
                this._totalRead += (long)read;
                this._buffer.retain();
                if (this._length < 0L || this._totalRead < this._length) {
                    Content.Chunk chunk = Content.Chunk.asChunk(byteBuffer, false, this._buffer);
                    if (ignored == null) return chunk;
                    ignored.close();
                    return chunk;
                }
                Content.Chunk last = Content.Chunk.asChunk(byteBuffer, true, this._buffer);
                this.lockedSetTerminal(Content.Chunk.EOF);
                Content.Chunk chunk = last;
                if (ignored == null) return chunk;
                ignored.close();
                return chunk;
            }
            catch (Throwable t2) {
                this.lockedSetTerminal(Content.Chunk.from(t2, true));
                return this._terminal;
            }
        }
        this.lockedSetTerminal(Content.Chunk.EOF);
        return this._terminal;
    }

    @Override
    public void fail(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            this.lockedSetTerminal(Content.Chunk.from(failure, true));
        }
    }

    @Override
    public long getLength() {
        return this._length;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean rewind() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class PathContentSource
    extends ByteChannelContentSource {
        private final Path _path;

        public PathContentSource(Path path) {
            this(null, path, 0L, -1L);
        }

        public PathContentSource(ByteBufferPool.Sized byteBufferPool, Path path) {
            this(byteBufferPool, path, 0L, -1L);
        }

        public PathContentSource(ByteBufferPool.Sized byteBufferPool, Path path, long offset, long length) {
            super(byteBufferPool, null, offset, length < 0L ? PathContentSource.size(path) : length);
            this._path = path;
        }

        public Path getPath() {
            return this._path;
        }

        @Override
        protected ByteChannel open() throws IOException {
            return Files.newByteChannel(this._path, StandardOpenOption.READ);
        }

        private static long size(Path path) {
            try {
                return Files.size(path);
            }
            catch (IOException e) {
                return -1L;
            }
        }
    }
}

