/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;

public class LegacyQuotedStringTokenizer
implements QuotedStringTokenizer {
    private final String _delim;
    private final boolean _returnQuotes;
    private final boolean _returnDelimiters;
    private final boolean _singleQuotes;

    LegacyQuotedStringTokenizer(String delim, boolean returnDelimiters, boolean returnQuotes, boolean singleQuotes) {
        this._delim = delim == null ? "\t\n\r" : delim;
        this._returnDelimiters = returnDelimiters;
        this._returnQuotes = returnQuotes;
        this._singleQuotes = singleQuotes;
    }

    @Override
    public Iterator<String> tokenize(String string) {
        final LegacyTokenizer tokenizer = new LegacyTokenizer(string);
        return new Iterator<String>(this){
            final /* synthetic */ LegacyQuotedStringTokenizer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }
        };
    }

    @Override
    public boolean needsQuoting(char c) {
        return LegacyTokenizer.needsQuoting(c, this._delim);
    }

    @Override
    public String quoteIfNeeded(String s2) {
        return LegacyTokenizer.quoteIfNeeded(s2, this._delim);
    }

    @Override
    public void quoteIfNeeded(StringBuilder buf, String str) {
        LegacyTokenizer.quoteIfNeeded(buf, str, this._delim);
    }

    @Override
    public void quote(Appendable buffer, String input) {
        LegacyTokenizer.quote(buffer, input);
    }

    @Override
    public String unquote(String s2) {
        return LegacyTokenizer.unquote(s2);
    }

    private class LegacyTokenizer
    extends StringTokenizer {
        private final String _string;
        private final StringBuffer _token;
        private boolean _hasToken;
        private int _i;
        private static final char[] escapes = new char[32];

        public LegacyTokenizer(String str) {
            super("");
            this._hasToken = false;
            this._i = 0;
            this._string = str;
            if (LegacyQuotedStringTokenizer.this._delim.indexOf(39) >= 0 || LegacyQuotedStringTokenizer.this._delim.indexOf(34) >= 0) {
                throw new Error("Can't use quotes as delimiters: " + LegacyQuotedStringTokenizer.this._delim);
            }
            this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
        }

        @Override
        public boolean hasMoreTokens() {
            if (this._hasToken) {
                return true;
            }
            int state = 0;
            boolean escape = false;
            block6: while (this._i < this._string.length()) {
                char c = this._string.charAt(this._i++);
                switch (state) {
                    case 0: {
                        if (LegacyQuotedStringTokenizer.this._delim.indexOf(c) >= 0) {
                            if (!LegacyQuotedStringTokenizer.this._returnDelimiters) continue block6;
                            this._token.append(c);
                            this._hasToken = true;
                            return true;
                        }
                        if (c == '\'' && LegacyQuotedStringTokenizer.this._singleQuotes) {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            state = 2;
                            continue block6;
                        }
                        if (c == '\"') {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            state = 3;
                            continue block6;
                        }
                        this._token.append(c);
                        this._hasToken = true;
                        state = 1;
                        continue block6;
                    }
                    case 1: {
                        this._hasToken = true;
                        if (LegacyQuotedStringTokenizer.this._delim.indexOf(c) >= 0) {
                            if (LegacyQuotedStringTokenizer.this._returnDelimiters) {
                                --this._i;
                            }
                            return this._hasToken;
                        }
                        if (c == '\'' && LegacyQuotedStringTokenizer.this._singleQuotes) {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            state = 2;
                            continue block6;
                        }
                        if (c == '\"') {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            state = 3;
                            continue block6;
                        }
                        this._token.append(c);
                        continue block6;
                    }
                    case 2: {
                        this._hasToken = true;
                        if (escape) {
                            escape = false;
                            this._token.append(c);
                            continue block6;
                        }
                        if (c == '\'') {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            state = 1;
                            continue block6;
                        }
                        if (c == '\\') {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            escape = true;
                            continue block6;
                        }
                        this._token.append(c);
                        continue block6;
                    }
                    case 3: {
                        this._hasToken = true;
                        if (escape) {
                            escape = false;
                            this._token.append(c);
                            continue block6;
                        }
                        if (c == '\"') {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            state = 1;
                            continue block6;
                        }
                        if (c == '\\') {
                            if (LegacyQuotedStringTokenizer.this._returnQuotes) {
                                this._token.append(c);
                            }
                            escape = true;
                            continue block6;
                        }
                        this._token.append(c);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            return this._hasToken;
        }

        @Override
        public String nextToken() throws NoSuchElementException {
            if (!this.hasMoreTokens() || this._token == null) {
                throw new NoSuchElementException();
            }
            String t2 = this._token.toString();
            this._token.setLength(0);
            this._hasToken = false;
            return t2;
        }

        @Override
        public String nextToken(String delim) throws NoSuchElementException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int countTokens() {
            return -1;
        }

        public static boolean needsQuoting(char c, String delim) {
            return c == '\\' || c == '\"' || c == '\'' || Character.isWhitespace(c) || delim.indexOf(c) >= 0;
        }

        public static String quoteIfNeeded(String s2, String delim) {
            if (s2 == null) {
                return null;
            }
            if (s2.length() == 0) {
                return "\"\"";
            }
            for (int i = 0; i < s2.length(); ++i) {
                char c = s2.charAt(i);
                if (!LegacyTokenizer.needsQuoting(c, delim)) continue;
                StringBuffer b = new StringBuffer(s2.length() + 8);
                LegacyTokenizer.quote(b, s2);
                return b.toString();
            }
            return s2;
        }

        public static void quoteIfNeeded(StringBuilder buf, String str, String delim) {
            if (str == null) {
                return;
            }
            int len = str.length();
            if (len == 0) {
                return;
            }
            for (int i = 0; i < len; ++i) {
                int ch = str.codePointAt(i);
                if (delim.indexOf(ch) < 0) continue;
                LegacyTokenizer.quote(buf, str);
                return;
            }
            buf.append(str);
        }

        public static String quote(String s2) {
            if (s2 == null) {
                return null;
            }
            if (s2.length() == 0) {
                return "\"\"";
            }
            StringBuffer b = new StringBuffer(s2.length() + 8);
            LegacyTokenizer.quote(b, s2);
            return b.toString();
        }

        public static void quote(Appendable buffer, String input) {
            if (input == null) {
                return;
            }
            try {
                buffer.append('\"');
                for (int i = 0; i < input.length(); ++i) {
                    char c = input.charAt(i);
                    if (c >= ' ') {
                        if (c == '\"' || c == '\\') {
                            buffer.append('\\');
                        }
                        buffer.append(c);
                        continue;
                    }
                    char escape = escapes[c];
                    if (escape == '\uffff') {
                        buffer.append('\\').append('u').append('0').append('0');
                        if (c < '\u0010') {
                            buffer.append('0');
                        }
                        buffer.append(Integer.toString(c, 16));
                        continue;
                    }
                    buffer.append('\\').append(escape);
                }
                buffer.append('\"');
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }

        public static String unquote(String s2) {
            return LegacyTokenizer.unquote(s2, false);
        }

        public static String unquote(String s2, boolean lenient) {
            char last;
            if (s2 == null) {
                return null;
            }
            if (s2.length() < 2) {
                return s2;
            }
            char first = s2.charAt(0);
            if (first != (last = s2.charAt(s2.length() - 1)) || first != '\"' && first != '\'') {
                return s2;
            }
            StringBuilder b = new StringBuilder(s2.length() - 2);
            boolean escape = false;
            for (int i = 1; i < s2.length() - 1; ++i) {
                char c = s2.charAt(i);
                if (escape) {
                    escape = false;
                    switch (c) {
                        case 'n': {
                            b.append('\n');
                            break;
                        }
                        case 'r': {
                            b.append('\r');
                            break;
                        }
                        case 't': {
                            b.append('\t');
                            break;
                        }
                        case 'f': {
                            b.append('\f');
                            break;
                        }
                        case 'b': {
                            b.append('\b');
                            break;
                        }
                        case '\\': {
                            b.append('\\');
                            break;
                        }
                        case '/': {
                            b.append('/');
                            break;
                        }
                        case '\"': {
                            b.append('\"');
                            break;
                        }
                        case 'u': {
                            b.append((char)((TypeUtil.convertHexDigit((byte)s2.charAt(i++)) << 24) + (TypeUtil.convertHexDigit((byte)s2.charAt(i++)) << 16) + (TypeUtil.convertHexDigit((byte)s2.charAt(i++)) << 8) + TypeUtil.convertHexDigit((byte)s2.charAt(i++))));
                            break;
                        }
                        default: {
                            if (lenient && !LegacyTokenizer.isValidEscaping(c)) {
                                b.append('\\');
                            }
                            b.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }

        private static boolean isValidEscaping(char c) {
            return c == 'n' || c == 'r' || c == 't' || c == 'f' || c == 'b' || c == '\\' || c == '/' || c == '\"' || c == 'u';
        }

        static {
            Arrays.fill(escapes, '\uffff');
            LegacyTokenizer.escapes[8] = 98;
            LegacyTokenizer.escapes[9] = 116;
            LegacyTokenizer.escapes[10] = 110;
            LegacyTokenizer.escapes[12] = 102;
            LegacyTokenizer.escapes[13] = 114;
        }
    }
}

