/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverterWithStrictJavaTypeCheck;

public class EnumConverter
extends AvroTypeConverterWithStrictJavaTypeCheck<String> {
    public static final AvroTypeConverter INSTANCE = new EnumConverter();

    private EnumConverter() {
        super(String.class);
    }

    @Override
    public Object convertValue(Schema.Field field, Schema schema, String value, Deque<String> path, boolean silently) {
        List<String> symbols = schema.getEnumSymbols();
        if (symbols.contains(value)) {
            return new GenericData.EnumSymbol(schema, value);
        }
        throw EnumConverter.enumException(path, symbols.stream().map(String::valueOf).collect(Collectors.joining(", ")));
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> path) {
        return schema.getType().equals((Object)Schema.Type.ENUM);
    }

    private static AvroTypeException enumException(Deque<String> fieldPath, String expectedSymbols) {
        return new AvroTypeException("Field " + PathsPrinter.print(fieldPath) + " is expected to be of enum type and be one of " + expectedSymbols);
    }
}

