/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import tech.allegro.schema.json2avro.converter.types.AbstractLongDateTimeConverter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public class LongTimestampMicrosConverter
extends AbstractLongDateTimeConverter {
    public static final AvroTypeConverter INSTANCE = new LongTimestampMicrosConverter(DateTimeFormatter.ISO_DATE_TIME);
    private final DateTimeFormatter dateTimeFormatter;

    public LongTimestampMicrosConverter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    protected Object convertDateTimeString(String dateTimeString) {
        Instant instant = this.parseInstant(dateTimeString);
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        if (seconds < 0L && nanos > 0) {
            long micros = Math.multiplyExact(seconds + 1L, 1000000L);
            long adjustment = (long)nanos / 1000L - 1000000L;
            return Math.addExact(micros, adjustment);
        }
        long micros = Math.multiplyExact(seconds, 1000000L);
        return Math.addExact(micros, (long)(nanos / 1000));
    }

    protected Instant parseInstant(String dateTimeString) {
        return Instant.from(this.dateTimeFormatter.parse(dateTimeString));
    }

    @Override
    protected LogicalType getLogicalType() {
        return LogicalTypes.timestampMicros();
    }

    @Override
    protected String getValidStringFormat() {
        return "date time";
    }

    @Override
    protected String getValidNumberFormat() {
        return "timestamp";
    }
}

