/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ModuleURIResolver;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xquery.XQueryEndpoint;
import org.apache.camel.component.xquery.XQueryModuleURIResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="xquery")
public class XQueryComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private ModuleURIResolver moduleURIResolver = new XQueryModuleURIResolver(this);
    @Metadata(label="advanced")
    private Configuration configuration;
    @Metadata(label="advanced")
    private Map<String, Object> configurationProperties = new HashMap<String, Object>();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        XQueryEndpoint answer = new XQueryEndpoint(uri, this);
        answer.setConfiguration(this.configuration);
        answer.setConfigurationProperties(this.getConfigurationProperties());
        this.setProperties(answer, parameters);
        answer.setResourceUri(remaining);
        answer.setModuleURIResolver(this.getModuleURIResolver());
        return answer;
    }

    public URL resolveModuleResource(String uri) throws Exception {
        return ResourceHelper.resolveMandatoryResourceAsUrl(this.getCamelContext(), uri);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Map<String, Object> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }
}

