/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.query.StaticQueryContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.component.xquery.ResultFormat;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.0.0", scheme="xquery", title="XQuery", syntax="xquery:resourceUri", remote=false, category={Category.TRANSFORMATION})
public class XQueryEndpoint
extends ProcessorEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(XQueryEndpoint.class);
    private volatile XQueryBuilder xquery;
    @UriPath
    @Metadata(required=true)
    private String resourceUri;
    @UriParam(label="advanced")
    private Configuration configuration;
    @UriParam(label="advanced")
    private Map<String, Object> configurationProperties = new HashMap<String, Object>();
    @UriParam(label="advanced")
    private StaticQueryContext staticQueryContext;
    @UriParam(label="advanced")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @UriParam
    private Map<String, String> namespacePrefixes = new HashMap<String, String>();
    @UriParam(defaultValue="DOM")
    private ResultFormat resultsFormat = ResultFormat.DOM;
    @UriParam(label="advanced")
    private Properties properties = new Properties();
    @UriParam
    private Class<?> resultType;
    @UriParam(defaultValue="true")
    private boolean stripsAllWhiteSpace = true;
    @UriParam(label="advanced")
    private ModuleURIResolver moduleURIResolver;
    @UriParam
    private boolean allowStAX;
    @UriParam
    private String source;

    public XQueryEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Map<String, Object> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public StaticQueryContext getStaticQueryContext() {
        return this.staticQueryContext;
    }

    public void setStaticQueryContext(StaticQueryContext staticQueryContext) {
        this.staticQueryContext = staticQueryContext;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public void setNamespacePrefixes(Map<String, String> namespacePrefixes) {
        this.namespacePrefixes = namespacePrefixes;
    }

    public ResultFormat getResultsFormat() {
        return this.resultsFormat;
    }

    public void setResultsFormat(ResultFormat resultsFormat) {
        this.resultsFormat = resultsFormat;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsAllWhiteSpace;
    }

    public void setStripsAllWhiteSpace(boolean stripsAllWhiteSpace) {
        this.stripsAllWhiteSpace = stripsAllWhiteSpace;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public boolean isAllowStAX() {
        return this.allowStAX;
    }

    public void setAllowStAX(boolean allowStAX) {
        this.allowStAX = allowStAX;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (ResourceHelper.isClasspathUri(this.resourceUri)) {
            this.doInitXQuery();
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (!ResourceHelper.isClasspathUri(this.resourceUri)) {
            this.doInitXQuery();
        }
        ServiceHelper.startService((Object)this.xquery);
    }

    protected void doInitXQuery() throws Exception {
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)this.resourceUri);
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), this.resourceUri);
        this.xquery = XQueryBuilder.xquery(is);
        this.xquery.setConfiguration(this.getConfiguration());
        this.xquery.setConfigurationProperties(this.getConfigurationProperties());
        this.xquery.setStaticQueryContext(this.getStaticQueryContext());
        this.xquery.setParameters(this.getParameters());
        this.xquery.setNamespaces(this.namespacePrefixes);
        this.xquery.setResultsFormat(this.getResultsFormat());
        this.xquery.setProperties(this.getProperties());
        this.xquery.setResultType(this.getResultType());
        this.xquery.setStripsAllWhiteSpace(this.isStripsAllWhiteSpace());
        this.xquery.setAllowStAX(this.isAllowStAX());
        this.xquery.setModuleURIResolver(this.getModuleURIResolver());
        this.xquery.setSource(ExpressionBuilder.singleInputExpression(this.getSource()));
        this.xquery.init(this.getCamelContext());
        this.setProcessor(this.xquery);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.xquery);
    }
}

