/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xquery;

import java.util.Map;
import net.sf.saxon.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="xquery")
public class XQueryLanguage
extends SingleInputTypedLanguageSupport
implements PropertyConfigurer {
    private Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Expression createExpression(Expression source, String expression, Object[] properties) {
        expression = this.loadResource(expression);
        XQueryBuilder builder = XQueryBuilder.xquery(expression);
        this.configureBuilder(builder, properties, source);
        return builder;
    }

    protected void configureBuilder(XQueryBuilder builder, Object[] properties, Expression source) {
        Map ns;
        builder.setSource(source);
        Class clazz = this.property(Class.class, properties, 0, null);
        if (clazz != null) {
            builder.setResultType(clazz);
        }
        if ((ns = this.property(Map.class, properties, 2, null)) != null && !ns.isEmpty()) {
            builder.setNamespaces(ns);
        }
        if (this.configuration != null) {
            builder.setConfiguration(this.configuration);
        }
    }

    @Override
    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "configuration": 
            case "Configuration": {
                this.setConfiguration(PropertyConfigurerSupport.property(camelContext, Configuration.class, value));
                return true;
            }
        }
        return false;
    }
}

