/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.function.Function;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;

public class MathFunctionSet
extends BuiltInFunctionSet {
    private static final MathFunctionSet THE_INSTANCE = new MathFunctionSet();

    public static MathFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    private MathFunctionSet() {
        this.init();
    }

    private void reg1(String name, Function<Double, Double> method) {
        this.register(name, 1, e -> e.populate(() -> new TrigFn1(method), BuiltInAtomicType.DOUBLE, 24576, 32768).arg(0, BuiltInAtomicType.DOUBLE, 24576, EMPTY));
    }

    private void init() {
        this.register("pi", 0, e -> e.populate(PiFn::new, BuiltInAtomicType.DOUBLE, 16384, 0));
        this.reg1("sin", Math::sin);
        this.reg1("cos", Math::cos);
        this.reg1("tan", Math::tan);
        this.reg1("asin", Math::asin);
        this.reg1("acos", Math::acos);
        this.reg1("atan", Math::atan);
        this.reg1("sqrt", Math::sqrt);
        this.reg1("log", Math::log);
        this.reg1("log10", Math::log10);
        this.reg1("exp", Math::exp);
        this.reg1("exp10", input -> Math.pow(10.0, input));
        this.register("pow", 2, e -> e.populate(PowFn::new, BuiltInAtomicType.DOUBLE, 24576, 32768).arg(0, BuiltInAtomicType.DOUBLE, 24576, EMPTY).arg(1, BuiltInAtomicType.DOUBLE, 16384, null));
        this.register("atan2", 2, e -> e.populate(Atan2Fn::new, BuiltInAtomicType.DOUBLE, 16384, 0).arg(0, BuiltInAtomicType.DOUBLE, 16384, null).arg(1, BuiltInAtomicType.DOUBLE, 16384, null));
    }

    @Override
    public NamespaceUri getNamespace() {
        return NamespaceUri.MATH;
    }

    @Override
    public String getConventionalPrefix() {
        return "math";
    }

    public static class Atan2Fn
    extends SystemFunction {
        @Override
        public DoubleValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            DoubleValue y = (DoubleValue)arguments[0].head();
            assert (y != null);
            DoubleValue x = (DoubleValue)arguments[1].head();
            assert (x != null);
            double result = Math.atan2(y.getDoubleValue(), x.getDoubleValue());
            return new DoubleValue(result);
        }
    }

    public static class PowFn
    extends SystemFunction {
        @Override
        public GroundedValue call(XPathContext context, Sequence[] args) throws XPathException {
            DoubleValue result;
            DoubleValue x = (DoubleValue)args[0].head();
            if (x == null) {
                return EmptySequence.getInstance();
            }
            double dx = x.getDoubleValue();
            if (dx == 1.0) {
                result = x;
            } else {
                NumericValue y = (NumericValue)args[1].head();
                assert (y != null);
                double dy = y.getDoubleValue();
                result = dx == -1.0 && Double.isInfinite(dy) ? new DoubleValue(1.0) : new DoubleValue(Math.pow(dx, dy));
            }
            return result;
        }
    }

    public static class TrigFn1
    extends SystemFunction {
        private final Function<Double, Double> method;

        public TrigFn1(Function<Double, Double> method) {
            this.method = method;
        }

        @Override
        public GroundedValue call(XPathContext context, Sequence[] args) throws XPathException {
            DoubleValue in = (DoubleValue)args[0].head();
            if (in == null) {
                return EmptySequence.getInstance();
            }
            return new DoubleValue(this.method.apply(in.getDoubleValue()));
        }
    }

    public static class PiFn
    extends SystemFunction {
        @Override
        public Expression makeFunctionCall(Expression ... arguments) {
            return Literal.makeLiteral(new DoubleValue(Math.PI));
        }

        @Override
        public DoubleValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new DoubleValue(Math.PI);
        }
    }
}

