/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.lang.annotation.Annotation;
import net.sf.saxon.functions.CollectionFn;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.xquery.ResultFormat;
import org.apache.camel.component.xquery.XQuery;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.apache.camel.support.language.NamespacePrefix;
import org.w3c.dom.Node;

public class XQueryAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        Class<Object> resultType;
        String source;
        String xQuery = this.getExpressionFromAnnotation(annotation);
        XQueryBuilder builder = XQueryBuilder.xquery(xQuery);
        if (annotation instanceof XQuery) {
            XQuery xQueryAnnotation = (XQuery)annotation;
            builder.setStripsAllWhiteSpace(xQueryAnnotation.stripsAllWhiteSpace());
            NamespacePrefix[] namespaces = xQueryAnnotation.namespaces();
            if (namespaces != null) {
                for (NamespacePrefix namespacePrefix : namespaces) {
                    builder = builder.namespace(namespacePrefix.prefix(), namespacePrefix.uri());
                }
            }
        }
        if ((source = this.getSource(annotation)) != null) {
            builder.setSource(ExpressionBuilder.singleInputExpression(source));
        }
        if ((resultType = this.getResultType(annotation)).equals(Object.class)) {
            resultType = expressionReturnType;
        }
        if (resultType.isAssignableFrom(String.class)) {
            builder.setResultsFormat(ResultFormat.String);
        } else if (resultType.isAssignableFrom(CollectionFn.class)) {
            builder.setResultsFormat(ResultFormat.List);
        } else if (resultType.isAssignableFrom(Node.class)) {
            builder.setResultsFormat(ResultFormat.DOM);
        } else if (resultType.isAssignableFrom(byte[].class)) {
            builder.setResultsFormat(ResultFormat.Bytes);
        }
        return builder;
    }

    protected Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }

    protected String getSource(Annotation annotation) {
        String answer = null;
        try {
            answer = (String)this.getAnnotationObjectValue(annotation, "source");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer != null && answer.isBlank()) {
            return null;
        }
        return answer;
    }
}

