/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.saxon;

import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConverterRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Converter(generateLoader=true)
public final class SaxonConverter {
    private SaxonConverter() {
    }

    @Converter
    public static Document toDOMDocument(TinyElementImpl node) throws XPathException {
        return SaxonConverter.toDOMDocument((NodeInfo)node);
    }

    @Converter
    public static Document toDOMDocument(TinyDocumentImpl node) throws XPathException {
        return SaxonConverter.toDOMDocument((NodeInfo)node);
    }

    @Converter
    public static Document toDOMDocument(NodeInfo node) throws XPathException {
        switch (node.getNodeKind()) {
            case 9: {
                return (Document)((Object)NodeOverNodeInfo.wrap(node));
            }
            case 1: {
                Configuration config = node.getConfiguration();
                TreeInfo documentInfo = config.buildDocumentTree(node);
                return (Document)((Object)NodeOverNodeInfo.wrap(documentInfo.getRootNode()));
            }
        }
        return null;
    }

    @Converter
    public static Node toDOMNode(TinyDocumentImpl node) {
        return SaxonConverter.toDOMNode((NodeInfo)node);
    }

    @Converter
    public static Node toDOMNode(NodeInfo node) {
        return NodeOverNodeInfo.wrap(node);
    }

    @Converter
    public static DOMSource toDOMSourceFromNodeInfo(TinyDocumentImpl nodeInfo) {
        return new DOMSource(SaxonConverter.toDOMNode(nodeInfo));
    }

    @Converter
    public static DOMSource toDOMSourceFromNodeInfo(NodeInfo nodeInfo) {
        return new DOMSource(SaxonConverter.toDOMNode(nodeInfo));
    }

    @Converter
    public static NodeList toDOMNodeList(List<? extends NodeInfo> nodeList) {
        LinkedList<Node> domNodeList = new LinkedList<Node>();
        if (nodeList != null) {
            for (NodeInfo nodeInfo : nodeList) {
                domNodeList.add(NodeOverNodeInfo.wrap(nodeInfo));
            }
        }
        return new DOMNodeList(domNodeList);
    }

    @Converter(fallback=true)
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        TypeConverter tc;
        if (NodeInfo.class.isAssignableFrom(value.getClass())) {
            NodeInfo ni = (NodeInfo)value;
            TypeConverter tc2 = registry.lookup(type, Node.class);
            if (tc2 != null) {
                NodeOverNodeInfo node = NodeOverNodeInfo.wrap(ni);
                return tc2.convertTo(type, exchange, node);
            }
            tc2 = registry.lookup(type, NodeList.class);
            if (tc2 != null) {
                LinkedList<NodeInfo> nil = new LinkedList<NodeInfo>();
                nil.add(ni);
                return tc2.convertTo(type, exchange, SaxonConverter.toDOMNodeList(nil));
            }
        } else if (List.class.isAssignableFrom(value.getClass())) {
            TypeConverter tc3 = registry.lookup(type, NodeList.class);
            if (tc3 != null) {
                LinkedList<NodeInfo> lion = new LinkedList<NodeInfo>();
                for (Object o : (List)value) {
                    if (!(o instanceof NodeInfo)) continue;
                    lion.add((NodeInfo)o);
                }
                if (!lion.isEmpty()) {
                    NodeList nl = SaxonConverter.toDOMNodeList(lion);
                    return tc3.convertTo(type, exchange, nl);
                }
            }
        } else if (NodeOverNodeInfo.class.isAssignableFrom(value.getClass()) && (tc = registry.lookup(type, NodeList.class)) != null) {
            LinkedList<Node> domNodeList = new LinkedList<Node>();
            domNodeList.add((NodeOverNodeInfo)value);
            return tc.convertTo(type, exchange, new DOMNodeList(domNodeList));
        }
        return null;
    }
}

