/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron.processor;

import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.component.schematron.exception.SchematronConfigException;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Node;

public final class TemplatesFactory {
    private static final TemplatesFactory INSTANCE = new TemplatesFactory();
    private static final String[] PIPELINE = new String[]{"iso_dsdl_include.xsl", "iso_abstract_expand.xsl", "iso_svrl_for_xslt2.xsl"};

    public static TemplatesFactory newInstance() {
        return INSTANCE;
    }

    public Templates getTemplates(InputStream rules, TransformerFactory fac) {
        Node node = null;
        Source source = new StreamSource(rules);
        try {
            for (String template : PIPELINE) {
                String path = "iso-schematron-xslt2".concat("/").concat(template);
                InputStream xsl = ObjectHelper.loadResourceAsStream(path);
                if (xsl == null) {
                    xsl = this.getClass().getClassLoader().getResourceAsStream(path);
                }
                Transformer t = fac.newTransformer(new StreamSource(xsl));
                DOMResult result = new DOMResult();
                t.transform(source, result);
                node = result.getNode();
                source = new DOMSource(node);
            }
            return fac.newTemplates(new DOMSource(node));
        }
        catch (Exception e) {
            throw new SchematronConfigException(e);
        }
    }
}

