/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.service;

import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.component.service.ServiceComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ServiceComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ServiceComponent target = (ServiceComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(ServiceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(ServiceComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "service": {
                target.setService(ServiceComponentConfigurer.property(camelContext, ServiceRegistry.class, value));
                return true;
            }
            case "serviceselector": 
            case "serviceSelector": {
                target.setServiceSelector(ServiceComponentConfigurer.property(camelContext, ServiceRegistry.Selector.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "service": {
                return ServiceRegistry.class;
            }
            case "serviceselector": 
            case "serviceSelector": {
                return ServiceRegistry.Selector.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ServiceComponent target = (ServiceComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "service": {
                return target.getService();
            }
            case "serviceselector": 
            case "serviceSelector": {
                return target.getServiceSelector();
            }
        }
        return null;
    }
}

