/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ServiceNowEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":instanceName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "servicenow".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "instanceName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(45);
        props.add("apiUrl");
        props.add("apiVersion");
        props.add("dateFormat");
        props.add("dateTimeFormat");
        props.add("display");
        props.add("displayValue");
        props.add("excludeReferenceLink");
        props.add("favorites");
        props.add("httpClientPolicy");
        props.add("includeAggregates");
        props.add("includeAvailableAggregates");
        props.add("includeAvailableBreakdowns");
        props.add("includeScoreNotes");
        props.add("includeScores");
        props.add("inputDisplayValue");
        props.add("instanceName");
        props.add("key");
        props.add("lazyStartProducer");
        props.add("mapper");
        props.add("models");
        props.add("oauthClientId");
        props.add("oauthClientSecret");
        props.add("oauthTokenUrl");
        props.add("password");
        props.add("perPage");
        props.add("proxyAuthorizationPolicy");
        props.add("proxyHost");
        props.add("proxyPassword");
        props.add("proxyPort");
        props.add("proxyUserName");
        props.add("release");
        props.add("requestModels");
        props.add("resource");
        props.add("responseModels");
        props.add("retrieveTargetRecordOnImport");
        props.add("sortBy");
        props.add("sortDir");
        props.add("sslContextParameters");
        props.add("suppressAutoSysField");
        props.add("suppressPaginationHeader");
        props.add("table");
        props.add("target");
        props.add("timeFormat");
        props.add("topLevelOnly");
        props.add("userName");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("oauthClientId");
        secretProps.add("oauthClientSecret");
        secretProps.add("oauthTokenUrl");
        secretProps.add("password");
        secretProps.add("userName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(3);
        prefixes.add("model.");
        prefixes.add("request-model.");
        prefixes.add("response-model.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

