/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public final class ServiceNowHelper {
    private ServiceNowHelper() {
    }

    public static void findOffsets(Response response, BiConsumer<String, Object> consumer) throws Exception {
        List links = (List)response.getStringHeaders().get("Link");
        if (links != null) {
            for (String link : links) {
                String[] parts = link.split(";");
                if (parts.length != 2) continue;
                String uri = StringHelper.between(parts[0], "<", ">");
                String rel = StringHelper.removeQuotes(StringHelper.after(parts[1], "="));
                Map<String, Object> query = URISupport.parseQuery(uri);
                Object offset = query.get(ServiceNowParams.SYSPARM_OFFSET.getId());
                if (offset == null) continue;
                switch (rel) {
                    case "first": {
                        consumer.accept("CamelServiceNowOffsetFirst", offset);
                        break;
                    }
                    case "last": {
                        consumer.accept("CamelServiceNowOffsetLast", offset);
                        break;
                    }
                    case "next": {
                        consumer.accept("CamelServiceNowOffsetNext", offset);
                        break;
                    }
                    case "prev": {
                        consumer.accept("CamelServiceNowOffsetPrev", offset);
                        break;
                    }
                }
            }
        }
    }

    public static Optional<String> findOffset(Response response, String type) throws Exception {
        List links = (List)response.getStringHeaders().get("Link");
        if (links != null) {
            for (String link : links) {
                String[] parts = link.split(";");
                if (parts.length != 2) continue;
                String uri = StringHelper.between(parts[0], "<", ">");
                String rel = StringHelper.removeQuotes(StringHelper.after(parts[1], "="));
                Map<String, Object> query = URISupport.parseQuery(uri);
                Object offset = query.get(ServiceNowParams.SYSPARM_OFFSET.getId());
                if (offset == null || !type.equals(rel)) continue;
                return Optional.of(offset.toString());
            }
        }
        return Optional.empty();
    }
}

