/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public abstract class AbstractContentEncryptionCipherProperties
implements ContentEncryptionCipherProperties {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractContentEncryptionCipherProperties.class);
    private static final int DEFAULT_AUTH_TAG_LENGTH = 128;
    private final ContentAlgorithm algo;

    public AbstractContentEncryptionCipherProperties(ContentAlgorithm algo) {
        this.algo = algo;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
        return CryptoUtils.getContentEncryptionCipherSpec(this.getAuthTagLen(), theIv);
    }

    @Override
    public byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
        return JweUtils.getAdditionalAuthenticationData(headersJson, aad);
    }

    protected int getAuthTagLen() {
        return 128;
    }

    @Override
    public ContentAlgorithm getAlgorithm() {
        return this.algo;
    }
}

