/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.servicenow.ServiceNowComponent;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowConstants;
import org.apache.camel.component.servicenow.ServiceNowProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.18.0", scheme="servicenow", title="ServiceNow", syntax="servicenow:instanceName", producerOnly=true, category={Category.API, Category.CLOUD, Category.MANAGEMENT}, headersClass=ServiceNowConstants.class)
public class ServiceNowEndpoint
extends DefaultEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceNowEndpoint.class);
    @UriPath(description="The ServiceNow instance name")
    @Metadata(required=true)
    private final String instanceName;
    @UriParam
    private final ServiceNowConfiguration configuration;

    public ServiceNowEndpoint(String uri, ServiceNowComponent component, ServiceNowConfiguration configuration, String instanceName) {
        super(uri, component);
        this.configuration = configuration;
        this.instanceName = instanceName;
    }

    @Override
    public Producer createProducer() throws Exception {
        ServiceNowProducer producer = this.configuration.getRelease().get(this);
        LOGGER.info("Producer for ServiceNow Rel. {} = {}/{}", new Object[]{this.configuration.getRelease().name(), producer.getRelease().name(), producer.getClass().getName()});
        return producer;
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not supported");
    }

    public ServiceNowConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getInstanceName() {
        return this.instanceName;
    }
}

