/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.auth;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.auth.OAuthToken;

@Provider
@Priority(value=1000)
public final class AuthenticationRequestFilter
implements ClientRequestFilter {
    private final OAuthToken authToken;
    private final String authString;

    public AuthenticationRequestFilter(ServiceNowConfiguration conf) {
        this.authToken = conf.hasOAuthAuthentication() ? new OAuthToken(conf) : null;
        this.authString = conf.hasBasicAuthentication() ? AuthenticationRequestFilter.getBasicAuthenticationString(conf) : null;
    }

    @Override
    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.authToken != null) {
            requestContext.getHeaders().add("Authorization", this.authToken.getAuthString());
        } else if (this.authString != null) {
            requestContext.getHeaders().add("Authorization", this.authString);
        }
    }

    private static String getBasicAuthenticationString(ServiceNowConfiguration conf) {
        String userAndPassword = conf.getUserName() + ":" + conf.getPassword();
        return "Basic " + Base64.getEncoder().encodeToString(userAndPassword.getBytes(StandardCharsets.UTF_8));
    }
}

