/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsonp;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class JsonpInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String JSONP_TYPE = "application/x-javascript";
    public static final String CALLBACK_PARAM = "_jsonp";
    public static final String CALLBACK_KEY = "JSONP.CALLBACK";
    public static final String DEFAULT_CALLBACK_VALUE = "callback";
    private String callbackParam = "_jsonp";
    private String defaultCallback = "callback";
    private String acceptType;
    private String mediaType = "application/x-javascript";

    public JsonpInInterceptor() {
        this("unmarshal");
    }

    public JsonpInInterceptor(String phase) {
        super(phase);
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        String callbackValue = this.getCallbackValue(message);
        if (!StringUtils.isEmpty(callbackValue)) {
            if (this.getAcceptType() != null) {
                message.put("Accept", this.getAcceptType());
            }
            message.getExchange().put(CALLBACK_KEY, callbackValue);
        }
    }

    protected String getCallbackValue(Message message) {
        String theQuery = (String)message.get(Message.QUERY_STRING);
        String callback = JAXRSUtils.getStructuredParams(theQuery, "&", false, false).getFirst(this.callbackParam);
        if (StringUtils.isEmpty(callback)) {
            String httpAcceptType = (String)message.get("Accept");
            if (this.mediaType != null && this.mediaType.equals(httpAcceptType)) {
                return this.defaultCallback;
            }
        }
        return callback;
    }

    public void setCallbackParam(String callbackParam) {
        this.callbackParam = callbackParam;
    }

    public String getCallbackParam() {
        return this.callbackParam;
    }

    public void setAcceptType(String acceptType) {
        this.acceptType = acceptType;
    }

    public String getAcceptType() {
        return this.acceptType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setDefaultCallback(String defaultCallback) {
        this.defaultCallback = defaultCallback;
    }

    public String getDefaultCallback() {
        return this.defaultCallback;
    }
}

