/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class AccessTokenValidatorClient
implements AccessTokenValidator {
    private WebClient tokenValidatorClient;
    private List<String> supportedSchemes = new LinkedList<String>();

    @Override
    public List<String> getSupportedAuthorizationSchemes() {
        return this.supportedSchemes.isEmpty() ? Collections.singletonList("*") : Collections.unmodifiableList(this.supportedSchemes);
    }

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps) throws OAuthServiceException {
        WebClient client = WebClient.fromClient(this.tokenValidatorClient, true);
        MetadataMap<String, String> props = new MetadataMap<String, String>();
        props.putSingle("authScheme", authScheme);
        props.putSingle("authSchemeData", authSchemeData);
        if (extraProps != null) {
            props.putAll((Map<String, String>)extraProps);
        }
        try {
            return client.post(props, AccessTokenValidation.class);
        }
        catch (WebApplicationException ex) {
            throw new OAuthServiceException(ex);
        }
    }

    public void setTokenValidatorClient(WebClient tokenValidatorClient) {
        this.tokenValidatorClient = tokenValidatorClient;
    }

    public void setSupportedSchemes(List<String> schemes) {
        this.supportedSchemes.addAll(schemes);
    }

    public void setSupportedScheme(String scheme) {
        this.supportedSchemes.add(scheme);
    }
}

