/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.owner;

import jakarta.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.owner.ResourceOwnerLoginHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class ResourceOwnerGrantHandler
extends AbstractGrantHandler {
    private ResourceOwnerLoginHandler loginHandler;

    public ResourceOwnerGrantHandler() {
        super("password");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String ownerName = params.getFirst("username");
        String ownerPassword = params.getFirst("password");
        if (ownerName == null || ownerPassword == null) {
            throw new OAuthServiceException(new OAuthError("invalid_request"));
        }
        UserSubject subject = this.loginHandler.createSubject(client, ownerName, ownerPassword);
        if (subject == null) {
            throw new OAuthServiceException("invalid_grant");
        }
        return this.doCreateAccessToken(client, subject, params);
    }

    public ResourceOwnerLoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    public void setLoginHandler(ResourceOwnerLoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    public void setMessageContext(MessageContext context) {
        if (this.loginHandler != null) {
            OAuthUtils.injectContextIntoOAuthProvider(context, this.loginHandler);
        }
    }
}

