/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.component.sjms.SjmsComponent;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SjmsComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        SjmsComponent target = (SjmsComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(SjmsComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(SjmsComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                target.setConnectionFactory(SjmsComponentConfigurer.property(camelContext, ConnectionFactory.class, value));
                return true;
            }
            case "destinationcreationstrategy": 
            case "destinationCreationStrategy": {
                target.setDestinationCreationStrategy(SjmsComponentConfigurer.property(camelContext, DestinationCreationStrategy.class, value));
                return true;
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                target.setExceptionListener(SjmsComponentConfigurer.property(camelContext, ExceptionListener.class, value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy(SjmsComponentConfigurer.property(camelContext, HeaderFilterStrategy.class, value));
                return true;
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                target.setJmsKeyFormatStrategy(SjmsComponentConfigurer.property(camelContext, JmsKeyFormatStrategy.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(SjmsComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                target.setMessageCreatedStrategy(SjmsComponentConfigurer.property(camelContext, MessageCreatedStrategy.class, value));
                return true;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                target.setRecoveryInterval(SjmsComponentConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                target.setReplyToOnTimeoutMaxConcurrentConsumers(SjmsComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                target.setRequestTimeoutCheckerInterval(SjmsComponentConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"connectionFactory"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return ConnectionFactory.class;
            }
            case "destinationcreationstrategy": 
            case "destinationCreationStrategy": {
                return DestinationCreationStrategy.class;
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                return ExceptionListener.class;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return HeaderFilterStrategy.class;
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                return JmsKeyFormatStrategy.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                return MessageCreatedStrategy.class;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return Long.TYPE;
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                return Integer.TYPE;
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                return Long.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        SjmsComponent target = (SjmsComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return target.getConnectionFactory();
            }
            case "destinationcreationstrategy": 
            case "destinationCreationStrategy": {
                return target.getDestinationCreationStrategy();
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                return target.getExceptionListener();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                return target.getJmsKeyFormatStrategy();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                return target.getMessageCreatedStrategy();
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return target.getRecoveryInterval();
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                return target.getReplyToOnTimeoutMaxConcurrentConsumers();
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                return target.getRequestTimeoutCheckerInterval();
            }
        }
        return null;
    }
}

