/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import jakarta.jms.Connection;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TransactionInProgressException;

public final class SjmsHelper {
    private SjmsHelper() {
    }

    public static void closeProducer(MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSession(Session ses) {
        if (ses != null) {
            try {
                ses.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeConsumer(MessageConsumer consumer) {
        if (consumer != null) {
            boolean interrupted = Thread.interrupted();
            try {
                consumer.close();
            }
            catch (JMSException jMSException) {
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static void commitIfNecessary(Session session) throws JMSException {
        try {
            session.commit();
        }
        catch (IllegalStateException | TransactionInProgressException throwable) {
            // empty catch block
        }
    }

    public static void commitIfNeeded(Session session, Message message) throws Exception {
        try {
            if (session.getTransacted()) {
                SjmsHelper.commitIfNecessary(session);
            } else if (message != null && session.getAcknowledgeMode() == 2) {
                message.acknowledge();
            }
        }
        catch (IllegalStateException | TransactionInProgressException throwable) {
            // empty catch block
        }
    }

    public static void rollbackIfNeeded(Session session) throws JMSException {
        if (session.getTransacted()) {
            try {
                session.rollback();
            }
            catch (IllegalStateException | TransactionInProgressException throwable) {}
        } else if (session.getAcknowledgeMode() == 2) {
            try {
                session.recover();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static boolean isTransactionOrClientAcknowledgeMode(Session session) throws JMSException {
        return session.getTransacted() || session.getAcknowledgeMode() == 2;
    }
}

