/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.reply;

import jakarta.jms.Message;
import jakarta.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.reply.ReplyHandler;
import org.apache.camel.component.sjms.reply.ReplyHolder;
import org.apache.camel.component.sjms.reply.ReplyManager;

public class TemporaryQueueReplyHandler
implements ReplyHandler {
    protected final ReplyManager replyManager;
    protected final Exchange exchange;
    protected final AsyncCallback callback;
    protected final String originalCorrelationId;
    protected final String correlationId;
    protected final long timeout;

    public TemporaryQueueReplyHandler(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long timeout) {
        this.replyManager = replyManager;
        this.exchange = exchange;
        this.originalCorrelationId = originalCorrelationId;
        this.correlationId = correlationId;
        this.callback = callback;
        this.timeout = timeout;
    }

    @Override
    public void onReply(String correlationId, Message reply, Session session) {
        ReplyHolder holder = new ReplyHolder(this.exchange, this.callback, this.originalCorrelationId, correlationId, reply, session);
        this.replyManager.processReply(holder);
    }

    @Override
    public void onTimeout(String correlationId) {
        ReplyHolder holder = new ReplyHolder(this.exchange, this.callback, this.originalCorrelationId, correlationId, this.timeout);
        this.replyManager.processReply(holder);
    }
}

