/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim2.impl;

import com.slack.api.scim2.SCIM2Config;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

public class ThreadPools {
    private static final ConcurrentMap<String, ConcurrentMap<String, ExecutorService>> ALL_DEFAULT = new ConcurrentHashMap<String, ConcurrentMap<String, ExecutorService>>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, ExecutorService>>> ENTERPRISE_CUSTOM = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, ExecutorService>>>();

    private ThreadPools() {
    }

    public static ExecutorService getDefault(SCIM2Config config) {
        return ThreadPools.getOrCreate(config, null);
    }

    public static ExecutorService getOrCreate(SCIM2Config config, String enterpriseId) {
        Integer orgCustomPoolSize;
        String providerInstanceId = config.getExecutorServiceProvider().getInstanceId();
        Integer n = orgCustomPoolSize = enterpriseId != null ? config.getCustomThreadPoolSizes().get(enterpriseId) : null;
        if (orgCustomPoolSize != null) {
            return ENTERPRISE_CUSTOM.computeIfAbsent(providerInstanceId, _id -> new ConcurrentHashMap()).computeIfAbsent(config.getExecutorName(), _name -> new ConcurrentHashMap()).computeIfAbsent(enterpriseId, _id -> ThreadPools.buildNewExecutorService(config, enterpriseId, orgCustomPoolSize));
        }
        return ALL_DEFAULT.computeIfAbsent(providerInstanceId, _id -> new ConcurrentHashMap()).computeIfAbsent(config.getExecutorName(), _name -> ThreadPools.buildNewExecutorService(config));
    }

    public static void shutdownAll(SCIM2Config config) {
        String providerInstanceId = config.getExecutorServiceProvider().getInstanceId();
        if (ENTERPRISE_CUSTOM.get(providerInstanceId) != null) {
            for (ConcurrentMap each : ((ConcurrentMap)ENTERPRISE_CUSTOM.get(providerInstanceId)).values()) {
                for (ExecutorService es : each.values()) {
                    es.shutdownNow();
                }
                each.clear();
            }
            ENTERPRISE_CUSTOM.remove(providerInstanceId);
        }
        if (ALL_DEFAULT.get(providerInstanceId) != null) {
            for (ExecutorService es : ((ConcurrentMap)ALL_DEFAULT.get(providerInstanceId)).values()) {
                es.shutdownNow();
            }
            ALL_DEFAULT.remove(providerInstanceId);
        }
    }

    private static ExecutorService buildNewExecutorService(SCIM2Config config) {
        String threadGroupName = "slack-scim2-" + config.getExecutorName();
        int poolSize = config.getDefaultThreadPoolSize();
        return config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, poolSize);
    }

    private static ExecutorService buildNewExecutorService(SCIM2Config config, String enterpriseId, Integer customPoolSize) {
        String threadGroupName = "slack-scim2-" + config.getExecutorName() + "-" + enterpriseId;
        return config.getExecutorServiceProvider().createThreadPoolExecutor(threadGroupName, customPoolSize);
    }
}

