/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.http;

import com.slack.api.meta.SlackApiClientLibraryVersion;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAgentInterceptor.class);
    public static final String USER_AGENT_PREFIX = "Java-Slack-SDK; ";
    private final String userAgent;

    public UserAgentInterceptor(Map<String, String> additionalInfo) {
        this.userAgent = UserAgentInterceptor.buildDefaultUserAgent(additionalInfo);
    }

    public static String buildDefaultUserAgent(Map<String, String> additionalInfo) {
        String libraryVersion = SlackApiClientLibraryVersion.get();
        String library = "slack-api-client/" + libraryVersion + "";
        String jvm = "" + System.getProperty("java.vm.name") + "/" + System.getProperty("java.version") + "";
        String os = "" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + "";
        String lastPart = "";
        for (Map.Entry<String, String> each : additionalInfo.entrySet()) {
            lastPart = lastPart + " " + each.getKey() + "/" + each.getValue() + ";";
        }
        return USER_AGENT_PREFIX + library + "; " + jvm + "; " + os + ";" + lastPart;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().header("User-Agent", this.userAgent).build();
        return chain.proceed(request);
    }
}

