/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import com.google.gson.Gson;
import com.slack.api.Slack;
import com.slack.api.SlackConfig;
import com.slack.api.methods.response.conversations.ConversationsListResponse;
import com.slack.api.model.ConversationType;
import com.slack.api.webhook.WebhookResponse;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.slack.CustomSlackHttpClient;
import org.apache.camel.component.slack.helper.SlackHelper;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.util.ObjectHelper;

public class SlackComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final Gson GSON = new Gson();

    public SlackComponentVerifierExtension() {
        this("slack");
    }

    public SlackComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    @Override
    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS);
        if (ObjectHelper.isEmpty(parameters.get("token")) && ObjectHelper.isEmpty(parameters.get("webhookUrl"))) {
            builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.GENERIC, "You must specify a webhookUrl (for producer) or a token (for producer and consumer)").parameterKey("webhookUrl").parameterKey("token").build());
        }
        if (ObjectHelper.isNotEmpty(parameters.get("token")) && ObjectHelper.isNotEmpty(parameters.get("webhookUrl"))) {
            builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.GENERIC, "You must specify a webhookUrl (for producer) or a token (for producer and consumer). You can't specify both.").parameterKey("webhookUrl").parameterKey("token").build());
        }
        return builder.build();
    }

    @Override
    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        Object response;
        SlackConfig config;
        String webhookUrl = (String)parameters.get("webhookUrl");
        String serverUrl = (String)parameters.get("serverUrl");
        if (ObjectHelper.isNotEmpty(webhookUrl)) {
            try {
                SlackMessage slackMessage = new SlackMessage();
                slackMessage.setText("Test connection");
                config = SlackHelper.createSlackConfig(serverUrl);
                response = Slack.getInstance(config, new CustomSlackHttpClient()).send(webhookUrl, GSON.toJson(slackMessage));
                if (((WebhookResponse)response).getCode() < 200 || ((WebhookResponse)response).getCode() > 299) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, "Invalid webhookUrl").parameterKey("webhookUrl").build());
                }
            }
            catch (Exception e) {
                builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, "Invalid webhookUrl").parameterKey("webhookUrl").build());
            }
        }
        if (ObjectHelper.isNotEmpty(parameters.get("token"))) {
            String token = (String)parameters.get("token");
            try {
                config = SlackHelper.createSlackConfig(serverUrl);
                response = Slack.getInstance(config, new CustomSlackHttpClient()).methods(token).conversationsList(req -> req.types(Collections.singletonList(ConversationType.PUBLIC_CHANNEL)).limit(1));
                if (!((ConversationsListResponse)response).isOk()) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, "Invalid token").parameterKey("token").build());
                }
            }
            catch (Exception e) {
                builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, "Invalid token").parameterKey("token").build());
            }
        }
    }
}

