/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.token_rotation.tooling.store;

import com.google.gson.Gson;
import com.slack.api.SlackConfig;
import com.slack.api.token_rotation.tooling.ToolingToken;
import com.slack.api.token_rotation.tooling.ToolingTokenStore;
import com.slack.api.util.json.GsonFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileToolingTokenStore
implements ToolingTokenStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileToolingTokenStore.class);
    public static final String DEFAULT_BASE_DIR = System.getProperty("user.home") + File.separator + ".slack-tooling-token";
    private static final Gson GSON;
    private final String baseDir;

    public FileToolingTokenStore() {
        this(DEFAULT_BASE_DIR);
    }

    private String toFilepath(String teamId, String userId) {
        return this.baseDir + File.separator + teamId + "-" + userId + ".json";
    }

    private String toFilepath(ToolingToken token) {
        return this.baseDir + File.separator + token.getTeamId() + "-" + token.getUserId() + ".json";
    }

    private static String loadFileContent(String filepath) throws IOException {
        String content = Files.readAllLines(Paths.get(filepath, new String[0])).stream().collect(Collectors.joining());
        if (content == null || content.trim().isEmpty() || content.trim().equals("null")) {
            return null;
        }
        return content;
    }

    public FileToolingTokenStore(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void save(ToolingToken token) {
        String path = this.toFilepath(token);
        String content = GSON.toJson(token);
        try {
            Files.write(Paths.get(path, new String[0]), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            log.warn("Failed to load a config file (path: {}, content: {})", new Object[]{path, content, e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<ToolingToken> find(String teamId, String userId) {
        try {
            String rawData = FileToolingTokenStore.loadFileContent(this.toFilepath(teamId, userId));
            return Optional.ofNullable(GSON.fromJson(rawData, ToolingToken.class));
        }
        catch (IOException e) {
            log.warn("Failed to load a config file (team_id: {}, user_id: {})", new Object[]{teamId, userId, e});
            return Optional.empty();
        }
    }

    static {
        SlackConfig config = new SlackConfig();
        config.setPrettyResponseLoggingEnabled(true);
        GSON = GsonFactory.createSnakeCase(config);
    }
}

