/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;

public class TokenPairExpressionIterator
extends ExpressionAdapter {
    protected final String startToken;
    protected final String endToken;
    protected final boolean includeTokens;
    private final Expression source;
    private Expression startExp;
    private Expression endExp;

    public TokenPairExpressionIterator(String startToken, String endToken, boolean includeTokens) {
        this(null, startToken, endToken, includeTokens);
    }

    public TokenPairExpressionIterator(Expression source, String startToken, String endToken, boolean includeTokens) {
        StringHelper.notEmpty(startToken, "startToken");
        StringHelper.notEmpty(endToken, "endToken");
        this.startToken = startToken;
        this.endToken = endToken;
        this.includeTokens = includeTokens;
        this.source = source;
    }

    @Override
    public void init(CamelContext context) {
        if (LanguageSupport.hasSimpleFunction(this.startToken)) {
            this.startExp = context.resolveLanguage("simple").createExpression(this.startToken);
            this.startExp.init(context);
        }
        if (LanguageSupport.hasSimpleFunction(this.endToken)) {
            this.endExp = context.resolveLanguage("simple").createExpression(this.endToken);
            this.endExp.init(context);
        }
    }

    @Override
    public boolean matches(Exchange exchange) {
        Object value = this.doEvaluate(exchange, true);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    @Override
    public Object evaluate(Exchange exchange) {
        return this.doEvaluate(exchange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doEvaluate(Exchange exchange, boolean closeStream) {
        Iterator<?> iterator2;
        block6: {
            InputStream in = null;
            try {
                in = this.source != null ? this.source.evaluate(exchange, InputStream.class) : exchange.getIn().getBody(InputStream.class);
                if (in == null) {
                    throw new InvalidPayloadException(exchange, InputStream.class);
                }
                String charset = ExchangeHelper.getCharsetName(exchange);
                iterator2 = this.createIterator(exchange, in, charset);
                if (!closeStream) break block6;
            }
            catch (InvalidPayloadException e) {
                Object var5_7;
                block7: {
                    try {
                        exchange.setException(e);
                        IOHelper.close(in);
                        var5_7 = null;
                        if (!closeStream) break block7;
                    }
                    catch (Throwable throwable) {
                        if (closeStream) {
                            IOHelper.close(in);
                        }
                        throw throwable;
                    }
                    IOHelper.close((Closeable)in);
                }
                return var5_7;
            }
            IOHelper.close((Closeable)in);
        }
        return iterator2;
    }

    protected Iterator<?> createIterator(Exchange exchange, InputStream in, String charset) {
        String start = this.startToken;
        if (this.startExp != null) {
            start = this.startExp.evaluate(exchange, String.class);
        }
        String end = this.endToken;
        if (this.endExp != null) {
            end = this.endExp.evaluate(exchange, String.class);
        }
        TokenPairIterator iterator2 = new TokenPairIterator(start, end, this.includeTokens, in, charset);
        iterator2.init();
        return iterator2;
    }

    public String toString() {
        return "tokenize[body() using tokens: " + this.startToken + "..." + this.endToken + "]";
    }

    static class TokenPairIterator
    implements Iterator<Object>,
    Closeable {
        final String startToken;
        String scanStartToken;
        final String endToken;
        String scanEndToken;
        final boolean includeTokens;
        final InputStream in;
        final String charset;
        Scanner scanner;
        Object image;

        TokenPairIterator(String startToken, String endToken, boolean includeTokens, InputStream in, String charset) {
            this.startToken = startToken;
            this.endToken = endToken;
            this.includeTokens = includeTokens;
            this.in = in;
            this.charset = charset;
            this.scanStartToken = startToken;
            if (this.scanStartToken.startsWith("[")) {
                this.scanStartToken = "\\" + this.scanStartToken;
            }
            if (this.scanStartToken.endsWith("]")) {
                this.scanStartToken = this.scanStartToken.substring(0, startToken.length() - 1) + "\\]";
            }
            this.scanEndToken = endToken;
            if (this.scanEndToken.startsWith("[")) {
                this.scanEndToken = "\\" + this.scanEndToken;
            }
            if (this.scanEndToken.endsWith("]")) {
                this.scanEndToken = this.scanEndToken.substring(0, this.scanEndToken.length() - 1) + "\\]";
            }
        }

        void init() {
            this.scanner = new Scanner(this.in, this.charset, this.scanEndToken);
            this.image = this.scanner.hasNext() ? this.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.image != null;
        }

        @Override
        public Object next() {
            Object answer = this.image;
            this.image = this.scanner.hasNext() ? this.getNext() : null;
            if (answer == null) {
                answer = this.image;
            }
            return answer;
        }

        Object getNext() {
            Object next = this.scanner.next();
            if (((String)next).contains(this.startToken)) {
                if ((next = StringHelper.after((String)next, this.startToken)) != null && this.includeTokens) {
                    next = this.startToken + (String)next + this.endToken;
                }
            } else {
                return null;
            }
            return next;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }
    }
}

