/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@Component(value="smb")
public class SmbComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty(remaining)) {
            throw new IllegalArgumentException("Host IP or address must be configured on endpoint using syntax smb:host:port");
        }
        SmbEndpoint endpoint = new SmbEndpoint(uri, this);
        String hostPart = StringHelper.before(remaining, "/");
        if (hostPart != null && hostPart.contains(":")) {
            SmbComponent.parseHost(hostPart, endpoint);
        } else {
            endpoint.setHostname(hostPart);
        }
        String path = StringHelper.after(remaining, "/");
        this.setProperties(endpoint, parameters);
        endpoint.setShareName(path);
        return endpoint;
    }

    private static void parseHost(String hostPart, SmbEndpoint endpoint) {
        String host = StringHelper.before(hostPart, ":");
        if (ObjectHelper.isEmpty(host)) {
            throw new IllegalArgumentException("Invalid host or address: " + hostPart);
        }
        endpoint.setHostname(host);
        String port = StringHelper.after(hostPart, ":");
        if (ObjectHelper.isEmpty(port)) {
            throw new IllegalArgumentException("Invalid port given on host: " + hostPart);
        }
        endpoint.setPort(Integer.parseInt(port));
    }
}

