/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb.converter;

import com.hierynomus.smbj.share.File;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.smb.converter.SmbConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class SmbConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;
    private volatile SmbConverter smbConverter;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SmbConverterLoader.addTypeConverter(registry, byte[].class, File.class, false, (type, exchange, value) -> this.getSmbConverter().toByteArray((File)value));
        SmbConverterLoader.addTypeConverter(registry, InputStream.class, File.class, false, (type, exchange, value) -> this.getSmbConverter().toInputStream((File)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

    private SmbConverter getSmbConverter() {
        if (this.smbConverter == null) {
            this.smbConverter = new SmbConverter();
            CamelContextAware.trySetCamelContext(this.smbConverter, this.camelContext);
        }
        return this.smbConverter;
    }
}

