/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.auth;

import com.hierynomus.asn1.ASN1OutputStream;
import com.hierynomus.asn1.encodingrules.der.DEREncoder;
import com.hierynomus.asn1.types.ASN1Object;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.primitive.ASN1ObjectIdentifier;
import com.hierynomus.ntlm.functions.NtlmFunctions;
import com.hierynomus.ntlm.messages.NtlmNegotiateFlag;
import com.hierynomus.ntlm.messages.WindowsVersion;
import com.hierynomus.security.SecurityProvider;
import com.hierynomus.smb.SMBBuffer;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticateResponse;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.auth.Authenticator;
import com.hierynomus.smbj.auth.NtlmAuthenticator;
import com.hierynomus.smbj.connection.ConnectionContext;
import com.hierynomus.spnego.NegTokenInit;
import com.hierynomus.spnego.NegTokenTarg;
import com.hierynomus.spnego.SpnegoToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmSealer
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(NtlmSealer.class);
    private static final byte[] C2S_SIGN_CONSTANT = "session key to client-to-server signing key magic constant\u0000".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] C2S_SEAL_CONSTANT = "session key to client-to-server sealing key magic constant\u0000".getBytes(StandardCharsets.US_ASCII);
    private NtlmAuthenticator wrapped;
    private SecurityProvider securityProvider;
    private byte[] signKey;
    private byte[] sealKey;
    private AtomicInteger sequenceNumber = new AtomicInteger(0);
    private List<ASN1ObjectIdentifier> mechTypes;

    public NtlmSealer(NtlmAuthenticator wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public AuthenticateResponse authenticate(AuthenticationContext context, byte[] gssToken, ConnectionContext connectionContext) throws IOException {
        SpnegoToken negToken;
        AuthenticateResponse resp = this.wrapped.authenticate(context, gssToken, connectionContext);
        if (resp == null) {
            return null;
        }
        byte[] sessionKey = resp.getSessionKey();
        Set<NtlmNegotiateFlag> negotiateFlags = resp.getNegotiateFlags();
        if (sessionKey != null) {
            logger.debug("Calculating signing and sealing keys for NTLM Extended Session Security");
            this.signKey = this.deriveSigningKey(sessionKey, negotiateFlags);
            this.sealKey = this.deriveSealingKey(sessionKey, negotiateFlags, resp.getWindowsVersion());
        }
        if (resp.getNegToken() instanceof NegTokenInit) {
            negToken = (NegTokenInit)resp.getNegToken();
            this.mechTypes = ((NegTokenInit)negToken).getSupportedMechTypes();
        }
        if (this.signKey != null && resp.getNegToken() instanceof NegTokenTarg) {
            negToken = (NegTokenTarg)resp.getNegToken();
            logger.debug("Signing with NTLM Extended Session Security");
            int sequenceNumber = this.sequenceNumber.getAndIncrement();
            byte[] signature = this.sign(this.signKey, sequenceNumber);
            if (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_KEY_EXCH)) {
                signature = NtlmFunctions.rc4k(this.securityProvider, this.sealKey, signature);
            }
            SMBBuffer buffer = new SMBBuffer();
            buffer.putUInt32(1L);
            buffer.putRawBytes(signature, 0, 8);
            buffer.putUInt32(sequenceNumber);
            ((NegTokenTarg)negToken).setMechListMic(buffer.getCompactData());
        }
        return resp;
    }

    private byte[] sign(byte[] signKey, int sequenceNumber) throws IOException {
        byte[] seq = this.uint32(sequenceNumber);
        byte[] data = this.derBytes(this.mechTypes);
        byte[] mac = NtlmFunctions.hmac_md5(this.securityProvider, signKey, seq, data);
        byte[] signature = new byte[8];
        System.arraycopy(mac, 0, signature, 0, 8);
        return signature;
    }

    private byte[] uint32(int value) {
        return new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
    }

    private byte[] derBytes(List<ASN1ObjectIdentifier> mechTypes) throws IOException {
        ArrayList<ASN1Object> supportedMechVector = new ArrayList<ASN1Object>(mechTypes);
        ASN1Sequence o = new ASN1Sequence(supportedMechVector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ASN1OutputStream out = new ASN1OutputStream(new DEREncoder(), baos);){
            out.writeObject(o);
        }
        return baos.toByteArray();
    }

    private byte[] deriveSigningKey(byte[] sessionKey, Set<NtlmNegotiateFlag> negotiateFlags) {
        if (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY)) {
            return NtlmFunctions.md5(this.securityProvider, sessionKey, C2S_SIGN_CONSTANT);
        }
        return null;
    }

    private byte[] deriveSealingKey(byte[] sessionKey, Set<NtlmNegotiateFlag> negotiateFlags, WindowsVersion windowsVersion) {
        if (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY)) {
            byte[] tmpKey = negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_128) ? sessionKey : (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_56) ? Arrays.copyOf(sessionKey, 7) : Arrays.copyOf(sessionKey, 5));
            return NtlmFunctions.md5(this.securityProvider, tmpKey, C2S_SEAL_CONSTANT);
        }
        if (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_LM_KEY) || negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_DATAGRAM) && windowsVersion.getNtlmRevision().getValue() >= WindowsVersion.NtlmRevisionCurrent.NTLMSSP_REVISION_W2K3.getValue()) {
            byte[] tmpKey = new byte[8];
            if (negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_56)) {
                System.arraycopy(sessionKey, 0, tmpKey, 0, 7);
                tmpKey[7] = -96;
            } else {
                System.arraycopy(sessionKey, 0, tmpKey, 0, 5);
                tmpKey[5] = -27;
                tmpKey[6] = 56;
                tmpKey[7] = -80;
            }
            return tmpKey;
        }
        return Arrays.copyOf(sessionKey, sessionKey.length);
    }

    @Override
    public void init(SmbConfig config) {
        this.wrapped.init(config);
        this.securityProvider = config.getSecurityProvider();
    }

    @Override
    public boolean supports(AuthenticationContext context) {
        return this.wrapped.supports(context);
    }
}

