/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileBinding;
import org.apache.camel.component.file.GenericFileConverter;

public class FileBinding
implements GenericFileBinding<File> {
    private File body;
    private byte[] content;

    @Override
    public Object getBody(GenericFile<File> file) {
        if (this.content != null) {
            return this.content;
        }
        if (this.body == null || !file.getAbsoluteFilePath().equals(this.body.getAbsolutePath())) {
            this.body = new File(file.getAbsoluteFilePath());
        }
        return this.body;
    }

    @Override
    public void setBody(GenericFile<File> file, Object body) {
    }

    @Override
    public void loadContent(Exchange exchange, GenericFile<?> file) throws IOException {
        Object data;
        if (this.content == null && (data = GenericFileConverter.convertTo(byte[].class, exchange, file, exchange.getContext().getTypeConverterRegistry())) != null) {
            this.content = (byte[])data;
        }
    }
}

