/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeProcessor
implements Processor {
    public static final String DATA_TYPE_PROPERTY = "CamelDataType";
    private static final Logger LOG = LoggerFactory.getLogger(DataTypeProcessor.class);
    private String fromType;
    private String toType;
    private boolean ignoreMissingDataType;
    private Transformer transformer;

    public DataTypeProcessor() {
    }

    public DataTypeProcessor(String fromType, String toType) {
        this.fromType = fromType;
        this.toType = toType;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.toType == null && exchange.hasProperties() && exchange.getProperties().containsKey(DATA_TYPE_PROPERTY)) {
            this.toType = exchange.getProperty(DATA_TYPE_PROPERTY, String.class);
        }
        if (this.toType == null || this.toType.isEmpty()) {
            return;
        }
        Message message = exchange.getMessage();
        DataType toDataType = new DataType(this.toType);
        DataType fromDataType = DataType.ANY;
        if (this.fromType != null) {
            fromDataType = new DataType(this.fromType);
        } else if (message instanceof DataTypeAware && ((DataTypeAware)((Object)message)).hasDataType()) {
            fromDataType = ((DataTypeAware)((Object)message)).getDataType();
        }
        Optional<Transformer> dataTypeTransformer = this.doLookupTransformer(exchange.getContext(), fromDataType, toDataType);
        if (dataTypeTransformer.isPresent()) {
            dataTypeTransformer.get().transform(message, fromDataType, toDataType);
        } else if (this.ignoreMissingDataType) {
            LOG.debug("Unable to find  data type transformer from {} to type {}", (Object)fromDataType, (Object)toDataType);
        } else {
            throw new CamelExecutionException(String.format("Missing data type transformer from %s to type %s", fromDataType, toDataType), exchange);
        }
    }

    private Optional<Transformer> doLookupTransformer(CamelContext context, DataType fromType, DataType toType) {
        if (this.transformer != null) {
            return Optional.of(this.transformer);
        }
        Transformer maybeTransformer = context.getTransformerRegistry().resolveTransformer(new TransformerKey(fromType, toType));
        if (maybeTransformer != null) {
            this.transformer = maybeTransformer;
            return Optional.of(maybeTransformer);
        }
        return Optional.empty();
    }

    public void setFromType(String fromType) {
        this.fromType = fromType;
    }

    public void setToType(String toType) {
        this.toType = toType;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public void setIgnoreMissingDataType(boolean ignoreMissingDataType) {
        this.ignoreMissingDataType = ignoreMissingDataType;
    }
}

