/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks.converter;

import java.util.List;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.smooks.converter.ResultConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.smooks.io.payload.JavaResult;
import org.smooks.io.payload.StringResult;
import org.w3c.dom.Node;

@DeferredContextBinding
public final class ResultConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ResultConverterLoader.addTypeConverter(registry, Double.class, JavaResult.ResultMap.class, false, (type, exchange, value) -> ResultConverter.toDouble((JavaResult.ResultMap)value));
        ResultConverterLoader.addTypeConverter(registry, Integer.class, JavaResult.ResultMap.class, false, (type, exchange, value) -> ResultConverter.toInteger((JavaResult.ResultMap)value));
        ResultConverterLoader.addTypeConverter(registry, String.class, StringResult.class, false, (type, exchange, value) -> ResultConverter.toString((StringResult)value));
        ResultConverterLoader.addTypeConverter(registry, List.class, JavaResult.ResultMap.class, false, (type, exchange, value) -> ResultConverter.toList((JavaResult.ResultMap)value, exchange));
        ResultConverterLoader.addTypeConverter(registry, StreamSource.class, StringResult.class, false, (type, exchange, value) -> ResultConverter.toStreamSource((StringResult)value));
        ResultConverterLoader.addTypeConverter(registry, Node.class, DOMResult.class, false, (type, exchange, value) -> ResultConverter.toDocument((DOMResult)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        ResultConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> ResultConverter.convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter(new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

