/*
 * Decompiled with CFR 0.152.
 */
package org.smooks;

import org.smooks.Smooks;
import org.smooks.StreamFilterType;
import org.smooks.engine.resource.config.ParameterAccessor;

public class FilterSettings {
    public static final FilterSettings DEFAULT_DOM = new FilterSettings(StreamFilterType.DOM);
    public static final FilterSettings DEFAULT_SAX_NG = new FilterSettings(StreamFilterType.SAX_NG);
    private StreamFilterType filterType = StreamFilterType.DOM;
    private boolean rewriteEntities = true;
    private boolean defaultSerializationOn = true;
    private boolean terminateOnException = true;
    private boolean maintainElementStack = true;
    private boolean closeSource = true;
    private boolean closeResult = true;
    private int readerPoolSize;
    private int maxNodeDepth = 1;

    public FilterSettings() {
    }

    public static FilterSettings newDOMSettings() {
        return new FilterSettings(StreamFilterType.DOM);
    }

    public static FilterSettings newSaxNgSettings() {
        return new FilterSettings(StreamFilterType.SAX_NG);
    }

    public FilterSettings(StreamFilterType filterType) {
        this.assertNonStaticDecl();
        this.filterType = filterType;
    }

    public FilterSettings setFilterType(StreamFilterType filterType) {
        this.assertNonStaticDecl();
        this.filterType = filterType;
        return this;
    }

    public FilterSettings setRewriteEntities(boolean rewriteEntities) {
        this.assertNonStaticDecl();
        this.rewriteEntities = rewriteEntities;
        return this;
    }

    public FilterSettings setDefaultSerializationOn(boolean defaultSerializationOn) {
        this.assertNonStaticDecl();
        this.defaultSerializationOn = defaultSerializationOn;
        return this;
    }

    public FilterSettings setTerminateOnException(boolean terminateOnException) {
        this.assertNonStaticDecl();
        this.terminateOnException = terminateOnException;
        return this;
    }

    public FilterSettings setMaintainElementStack(boolean maintainElementStack) {
        this.assertNonStaticDecl();
        this.maintainElementStack = maintainElementStack;
        return this;
    }

    public FilterSettings setCloseSource(boolean closeSource) {
        this.assertNonStaticDecl();
        this.closeSource = closeSource;
        return this;
    }

    public FilterSettings setCloseResult(boolean closeResult) {
        this.assertNonStaticDecl();
        this.closeResult = closeResult;
        return this;
    }

    public FilterSettings setReaderPoolSize(int readerPoolSize) {
        this.assertNonStaticDecl();
        this.readerPoolSize = readerPoolSize;
        return this;
    }

    public FilterSettings setMaxNodeDepth(int maxNodeDepth) {
        this.assertNonStaticDecl();
        this.maxNodeDepth = maxNodeDepth;
        return this;
    }

    protected void applySettings(Smooks smooks) {
        ParameterAccessor.removeParameter("stream.filter.type", smooks);
        ParameterAccessor.removeParameter("entities.rewrite", smooks);
        ParameterAccessor.removeParameter("default.serialization.on", smooks);
        ParameterAccessor.removeParameter("terminate.on.visitor.exception", smooks);
        ParameterAccessor.removeParameter("maintain.element.stack", smooks);
        ParameterAccessor.removeParameter("close.source", smooks);
        ParameterAccessor.removeParameter("close.result", smooks);
        ParameterAccessor.removeParameter("reader.pool.size", smooks);
        ParameterAccessor.removeParameter("max.node.depth", smooks);
        ParameterAccessor.setParameter("stream.filter.type", this.filterType.toString(), smooks);
        ParameterAccessor.setParameter("entities.rewrite", Boolean.toString(this.rewriteEntities), smooks);
        ParameterAccessor.setParameter("default.serialization.on", Boolean.toString(this.defaultSerializationOn), smooks);
        ParameterAccessor.setParameter("terminate.on.visitor.exception", Boolean.toString(this.terminateOnException), smooks);
        ParameterAccessor.setParameter("maintain.element.stack", Boolean.toString(this.maintainElementStack), smooks);
        ParameterAccessor.setParameter("close.source", Boolean.toString(this.closeSource), smooks);
        ParameterAccessor.setParameter("close.result", Boolean.toString(this.closeResult), smooks);
        ParameterAccessor.setParameter("reader.pool.size", Integer.toString(this.readerPoolSize), smooks);
        ParameterAccessor.setParameter("max.node.depth", Integer.toString(this.maxNodeDepth), smooks);
    }

    private void assertNonStaticDecl() {
        if (this == DEFAULT_DOM || this == DEFAULT_SAX_NG) {
            throw new UnsupportedOperationException("Invalid attempt to modify static filter type declaration.");
        }
    }
}

