/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import com.fasterxml.classmate.TypeResolver;
import jakarta.annotation.Resource;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.Registry;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.profile.ProfileStore;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.config.loader.ResourceConfigLoader;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.DefaultLifecycleManager;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lifecycle.PreDestroyLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.lookup.ResourceConfigSeqLookup;
import org.smooks.engine.lookup.ResourceConfigSeqsLookup;
import org.smooks.engine.lookup.converter.TypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfigSeq;

public class DefaultRegistry
implements Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(Registry.class);
    private final Map<Object, Object> registry = new ConcurrentHashMap<Object, Object>();
    private final ClassLoader classLoader;
    private final ResourceConfigLoader resourceConfigLoader;

    public DefaultRegistry(ClassLoader classLoader, ResourceConfigLoader resourceConfigLoader, ProfileStore profileStore) {
        AssertArgument.isNotNull(classLoader, "classLoader");
        AssertArgument.isNotNull(resourceConfigLoader, "resourceConfigLoader");
        AssertArgument.isNotNull(profileStore, "profileStore");
        this.classLoader = classLoader;
        this.registerObject(ProfileStore.class, profileStore);
        Set<TypeConverterFactory<?, ?>> typeConverterFactories = new TypeConverterFactoryLoader().load(classLoader);
        this.registerObject(TypeConverterFactoryLookup.TYPE_CONVERTER_FACTORY_REGISTRY_KEY, typeConverterFactories);
        this.registerObject(LifecycleManager.class, new DefaultLifecycleManager());
        DefaultResourceConfigSeq systemResourceConfigSeq = new DefaultResourceConfigSeq("default");
        systemResourceConfigSeq.setSystem(true);
        this.registerObject(ResourceConfigSeq.class, systemResourceConfigSeq);
        ArrayList<DefaultResourceConfigSeq> resourceConfigSeqs = new ArrayList<DefaultResourceConfigSeq>();
        resourceConfigSeqs.add(systemResourceConfigSeq);
        this.registerObject(new TypeResolver().resolve((Type)((Object)List.class), new Type[]{ResourceConfigSeq.class}), resourceConfigSeqs);
        this.resourceConfigLoader = resourceConfigLoader;
    }

    @Override
    public void registerObject(Object value) {
        String candidateName;
        AssertArgument.isNotNull(value, "value");
        String name = value.getClass().isAnnotationPresent(Resource.class) && !value.getClass().getAnnotation(Resource.class).name().isEmpty() ? (this.registry.containsKey(candidateName = value.getClass().getAnnotation(Resource.class).name()) ? candidateName + ":" + UUID.randomUUID() : candidateName) : value.getClass().getName() + ":" + UUID.randomUUID();
        this.registerObject(name, value);
    }

    @Override
    public void registerObject(Object key, Object value) {
        AssertArgument.isNotNull(key, "key");
        AssertArgument.isNotNull(value, "value");
        if (this.registry.putIfAbsent(key, value) != null) {
            throw new SmooksException(String.format("Duplicate registered object for object with key [%s]", key));
        }
    }

    @Override
    public void deRegisterObject(Object key) {
        this.registry.remove(key);
    }

    @Override
    public <R> R lookup(Function<Map<Object, Object>, R> function) {
        return function.apply(Collections.unmodifiableMap(this.registry));
    }

    @Override
    public <T> T lookup(Object key) {
        return (T)this.registry.get(key);
    }

    @Override
    public <T> T lookup(TypedKey<T> key) {
        return this.lookup((Object)key);
    }

    @Override
    public ResourceConfigSeq registerResources(String baseURI, InputStream inputStream) {
        AssertArgument.isNotEmpty(baseURI, "baseURI");
        AssertArgument.isNotNull(inputStream, "inputStream");
        ResourceConfigSeq resourceConfigSeq = this.resourceConfigLoader.load(inputStream, baseURI, this.classLoader);
        this.registerResourceConfigSeq(resourceConfigSeq);
        return resourceConfigSeq;
    }

    protected void addProfileSets(List<ProfileSet> profileSets) {
        ProfileStore profileStore = (ProfileStore)this.lookup(ProfileStore.class);
        if (profileSets == null) {
            return;
        }
        for (ProfileSet profileSet : profileSets) {
            profileStore.addProfileSet(profileSet);
        }
    }

    @Override
    public void registerResourceConfig(ResourceConfig resourceConfig) {
        AssertArgument.isNotNull(resourceConfig, "resourceConfig");
        this.lookup(new LifecycleManagerLookup()).applyPhase(resourceConfig, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this)));
        this.lookup(new ResourceConfigSeqLookup()).add(resourceConfig);
    }

    @Override
    public void registerResourceConfigSeq(ResourceConfigSeq resourceConfigSeq) {
        this.lookup(new ResourceConfigSeqsLookup()).add(resourceConfigSeq);
        this.lookup(new LifecycleManagerLookup()).applyPhase(resourceConfigSeq, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this)));
        this.addProfileSets(resourceConfigSeq.getProfiles());
    }

    @Override
    public void close() {
        LOGGER.debug("Un-initializing all ContentHandler instances allocated through this registry");
        for (Object registeredObject : this.registry.values()) {
            LOGGER.debug("Un-initializing ContentHandler instance: " + registeredObject.getClass().getName());
            try {
                this.lookup(new LifecycleManagerLookup()).applyPhase(registeredObject, (LifecyclePhase)new PreDestroyLifecyclePhase());
            }
            catch (Throwable throwable) {
                LOGGER.error("Error un-initializing " + registeredObject.getClass().getName() + ".", throwable);
            }
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

