/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.Objects;
import java.util.Properties;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.injector.FieldInjector;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;

public class DefaultContentHandlerBinding<T extends ContentHandler>
implements ContentHandlerBinding<T> {
    private final T contentHandler;
    private final ResourceConfig resourceConfig;
    private int hash;

    public DefaultContentHandlerBinding(T contentHandler, ResourceConfig resourceConfig) {
        this.contentHandler = contentHandler;
        this.resourceConfig = resourceConfig;
    }

    public DefaultContentHandlerBinding(T contentHandler, String targetSelector, Registry registry) {
        this.contentHandler = contentHandler;
        this.resourceConfig = new DefaultResourceConfig(targetSelector, registry.lookup(new NamespaceManagerLookup()).orElse(new Properties()), contentHandler.getClass().getName());
        FieldInjector fieldInjector = new FieldInjector(contentHandler, new Scope(registry, this.resourceConfig, contentHandler));
        fieldInjector.inject();
        registry.lookup(new LifecycleManagerLookup()).applyPhase(contentHandler, (LifecyclePhase)new PostConstructLifecyclePhase());
        registry.registerObject(contentHandler);
    }

    @Override
    public T getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentHandlerBinding)) {
            return false;
        }
        ContentHandlerBinding that = (ContentHandlerBinding)o;
        return Objects.equals(this.contentHandler, that.getContentHandler()) && Objects.equals(this.resourceConfig, that.getResourceConfig());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.contentHandler, this.resourceConfig);
        }
        return this.hash;
    }
}

