/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.fragment;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.saxpath.SAXPathException;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.expression.ExecutionContextExpressionEvaluator;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.JaxenPatternSelectorPath;
import org.smooks.engine.resource.config.xpath.step.AttributeSelectorStep;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public class NodeFragment
implements Fragment<Node> {
    protected static final UserDataHandler COPY_USER_DATA_HANDLER = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            dst.setUserData(key, data, this);
        }
    };
    public static final String RESERVATIONS_USER_DATA_KEY = "reservations";
    public static final String ID_USER_DATA_KEY = "id";
    private final Node node;
    private final boolean isReservationInheritable;
    private String id;
    private int hash;

    public NodeFragment(Node node) {
        this(node, false);
    }

    public NodeFragment(Node node, boolean isReservationInheritable) {
        this.node = node;
        this.isReservationInheritable = isReservationInheritable;
        HashMap<Long, Reservation> reservations = (HashMap<Long, Reservation>)node.getUserData(RESERVATIONS_USER_DATA_KEY);
        if (reservations == null) {
            reservations = new HashMap<Long, Reservation>();
            node.setUserData(RESERVATIONS_USER_DATA_KEY, reservations, COPY_USER_DATA_HANDLER);
        }
        for (Node parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            Map parentNodeReservations = (Map)parentNode.getUserData(RESERVATIONS_USER_DATA_KEY);
            if (parentNodeReservations == null || parentNodeReservations.isEmpty()) continue;
            reservations.putAll(parentNodeReservations.entrySet().stream().filter(e -> ((Reservation)e.getValue()).isInheritable()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = (String)this.node.getUserData(ID_USER_DATA_KEY);
            if (this.id == null) {
                this.id = String.valueOf(Math.abs(ThreadLocalRandom.current().nextLong()));
                this.node.setUserData(ID_USER_DATA_KEY, this.id, COPY_USER_DATA_HANDLER);
            }
        }
        return this.id;
    }

    @Override
    public Node unwrap() {
        return this.node;
    }

    @Override
    public boolean reserve(long id, Object token) {
        return ((Map)this.node.getUserData(RESERVATIONS_USER_DATA_KEY)).computeIfAbsent(id, key -> new Reservation(token, this.isReservationInheritable)).getToken().equals(token);
    }

    @Override
    public boolean release(long id, Object token) {
        Map reservedTokens = (Map)this.node.getUserData(RESERVATIONS_USER_DATA_KEY);
        Object reservedToken = reservedTokens.getOrDefault(id, new Reservation(token, this.isReservationInheritable)).getToken();
        if (reservedToken.equals(token)) {
            reservedTokens.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatch(SelectorPath selectorPath, ExecutionContext executionContext) {
        if (!this.assertConditionTrue(executionContext, selectorPath)) {
            return false;
        }
        try {
            return this.isPatternMatch(this.node, selectorPath) && this.evaluate(this.node, selectorPath, executionContext);
        }
        catch (SAXPathException e) {
            throw new SmooksException(e);
        }
    }

    protected boolean evaluate(Node node, SelectorPath selectorPath, ExecutionContext executionContext) throws JaxenException {
        Node nodeUnderTest = null;
        if (selectorPath instanceof IndexedSelectorPath && ((IndexedSelectorPath)selectorPath).getTargetSelectorStep() instanceof AttributeSelectorStep && node.getNodeType() == 1) {
            if (node.hasAttributes()) {
                AttributeSelectorStep attributeSelectorStep = (AttributeSelectorStep)((IndexedSelectorPath)selectorPath).getTargetSelectorStep();
                String namespaceURI = attributeSelectorStep.getQName().getNamespaceURI();
                nodeUnderTest = node.getAttributes().getNamedItemNS(namespaceURI.equals("") ? null : namespaceURI, attributeSelectorStep.getQName().getLocalPart());
            }
        } else {
            nodeUnderTest = node;
        }
        if (nodeUnderTest == null) {
            return false;
        }
        for (int i = selectorPath.size() - 1; i >= 0; --i) {
            if (!((SelectorStep)selectorPath.get(i)).evaluate(new NodeFragment(nodeUnderTest), executionContext)) {
                return false;
            }
            nodeUnderTest = nodeUnderTest.getNodeType() == 2 ? ((Attr)nodeUnderTest).getOwnerElement() : nodeUnderTest.getParentNode();
        }
        return true;
    }

    protected boolean isPatternMatch(Node node, SelectorPath selectorPath) throws JaxenException {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        Properties namespaces = selectorPath.getNamespaces();
        for (String namespacePrefix : namespaces.stringPropertyNames()) {
            simpleNamespaceContext.addNamespace(namespacePrefix, namespaces.getProperty(namespacePrefix));
        }
        Context context = new Context(new ContextSupport(simpleNamespaceContext, XPathFunctionContext.getInstance(), new SimpleVariableContext(), DocumentNavigator.getInstance()));
        boolean isMatch = true;
        if (selectorPath instanceof IndexedSelectorPath && ((IndexedSelectorPath)selectorPath).getTargetSelectorStep() instanceof AttributeSelectorStep && node.getNodeType() == 1) {
            if (node.hasAttributes()) {
                for (int i = 0; i < node.getAttributes().getLength() && !(isMatch = ((JaxenPatternSelectorPath)selectorPath).getPattern().matches(node.getAttributes().item(i), context)); ++i) {
                }
            } else {
                isMatch = false;
            }
        } else {
            isMatch = ((JaxenPatternSelectorPath)selectorPath).getPattern().matches(node, context);
        }
        return isMatch;
    }

    protected boolean assertConditionTrue(ExecutionContext executionContext, SelectorPath selectorPath) {
        if (selectorPath.getConditionEvaluator() == null) {
            return true;
        }
        return ((ExecutionContextExpressionEvaluator)selectorPath.getConditionEvaluator()).eval(executionContext);
    }

    public String toString() {
        return this.node.getNodeName();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.getId());
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeFragment)) {
            return false;
        }
        return this.getId().equals(((NodeFragment)o).getId());
    }

    protected static class Reservation {
        private final Object token;
        private final boolean inheritable;

        Reservation(Object token, boolean inheritable) {
            this.token = token;
            this.inheritable = inheritable;
        }

        public Object getToken() {
            return this.token;
        }

        public boolean isInheritable() {
            return this.inheritable;
        }
    }
}

