/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.interceptor.InterceptorVisitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;

public abstract class AbstractInterceptorVisitor
implements InterceptorVisitor {
    protected final VisitChildTextInvocation visitChildTextInvocation = new VisitChildTextInvocation();
    protected final VisitChildElementInvocation visitChildElementInvocation = new VisitChildElementInvocation();
    protected final VisitAfterInvocation visitAfterInvocation = new VisitAfterInvocation();
    protected final VisitBeforeInvocation visitBeforeInvocation = new VisitBeforeInvocation();
    protected final Map<Class<?>, Optional<Visitor>> invocationTargetCache = new ConcurrentHashMap();
    protected final AtomicReference<ContentHandlerBinding<Visitor>> target = new AtomicReference();
    protected ContentHandlerBinding<Visitor> visitorBinding;
    @Inject
    protected ApplicationContext applicationContext;

    @Override
    public void setVisitorBinding(ContentHandlerBinding<Visitor> visitorBinding) {
        this.visitorBinding = visitorBinding;
    }

    @Override
    public ContentHandlerBinding<Visitor> getVisitorBinding() {
        return this.visitorBinding;
    }

    @Override
    public ContentHandlerBinding<Visitor> getTarget() {
        if (this.target.get() == null) {
            ContentHandlerBinding<Visitor> nextVisitorBinding = this.visitorBinding;
            while (nextVisitorBinding.getContentHandler() instanceof InterceptorVisitor) {
                nextVisitorBinding = ((InterceptorVisitor)this.visitorBinding.getContentHandler()).getTarget();
            }
            this.target.compareAndSet(null, nextVisitorBinding);
        }
        return this.target.get();
    }

    protected <T extends Visitor> Object intercept(Invocation<T> invocation, Object ... args) {
        Class<?> invocationTargetClass = invocation.getTarget();
        Optional<Visitor> invocationTargetVisitorOptional = this.invocationTargetCache.get(invocationTargetClass);
        if (invocationTargetVisitorOptional == null) {
            ContentHandlerBinding<Visitor> nextVisitorBinding = this.visitorBinding;
            while (nextVisitorBinding != null) {
                Visitor nextVisitor = nextVisitorBinding.getContentHandler();
                if (invocationTargetClass.isInstance(nextVisitor)) {
                    invocationTargetVisitorOptional = Optional.of(nextVisitor);
                    this.invocationTargetCache.put(invocationTargetClass, invocationTargetVisitorOptional);
                    break;
                }
                if (nextVisitor instanceof InterceptorVisitor) {
                    nextVisitorBinding = ((InterceptorVisitor)nextVisitor).getVisitorBinding();
                    continue;
                }
                invocationTargetVisitorOptional = Optional.empty();
                this.invocationTargetCache.put(invocationTargetClass, invocationTargetVisitorOptional);
                break;
            }
        }
        if (invocationTargetVisitorOptional.isPresent()) {
            return invocation.invoke(invocationTargetVisitorOptional.get(), args);
        }
        return null;
    }

    protected static class VisitBeforeInvocation
    implements Invocation<BeforeVisitor> {
        protected VisitBeforeInvocation() {
        }

        @Override
        public Object invoke(BeforeVisitor visitor, Object ... args) {
            visitor.visitBefore((Element)args[0], (ExecutionContext)args[1]);
            return null;
        }

        @Override
        public Class<BeforeVisitor> getTarget() {
            return BeforeVisitor.class;
        }
    }

    protected static class VisitAfterInvocation
    implements Invocation<AfterVisitor> {
        protected VisitAfterInvocation() {
        }

        @Override
        public Object invoke(AfterVisitor visitor, Object ... args) {
            visitor.visitAfter((Element)args[0], (ExecutionContext)args[1]);
            return null;
        }

        @Override
        public Class<AfterVisitor> getTarget() {
            return AfterVisitor.class;
        }
    }

    protected static class VisitChildElementInvocation
    implements Invocation<ChildrenVisitor> {
        protected VisitChildElementInvocation() {
        }

        @Override
        public Object invoke(ChildrenVisitor visitor, Object ... args) {
            visitor.visitChildElement((Element)args[0], (ExecutionContext)args[1]);
            return null;
        }

        @Override
        public Class<ChildrenVisitor> getTarget() {
            return ChildrenVisitor.class;
        }
    }

    protected static class VisitChildTextInvocation
    implements Invocation<ChildrenVisitor> {
        protected VisitChildTextInvocation() {
        }

        @Override
        public Object invoke(ChildrenVisitor visitor, Object ... args) {
            visitor.visitChildText((CharacterData)args[0], (ExecutionContext)args[1]);
            return null;
        }

        @Override
        public Class<ChildrenVisitor> getTarget() {
            return ChildrenVisitor.class;
        }
    }

    public static interface Invocation<T extends Visitor> {
        public Object invoke(T var1, Object ... var2);

        public Class<?> getTarget();
    }
}

