/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import jakarta.annotation.PostConstruct;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.sax.TextConsumer;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.api.resource.visitor.sax.ng.ParameterizedVisitor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.interceptor.AbstractInterceptorVisitor;
import org.smooks.engine.memento.TextAccumulatorMemento;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;

public class TextConsumerInterceptor
extends AbstractInterceptorVisitor
implements ElementVisitor,
DOMElementVisitor {
    protected boolean isTextConsumer;

    @PostConstruct
    public void postConstruct() {
        ContentHandlerBinding<Visitor> visitorBinding = this.getTarget();
        this.isTextConsumer = !(visitorBinding.getContentHandler() instanceof ParameterizedVisitor) || ((ParameterizedVisitor)visitorBinding.getContentHandler()).getMaxNodeDepth() == 1 ? (visitorBinding.getContentHandler().getClass().isAnnotationPresent(TextConsumer.class) ? true : (visitorBinding.getContentHandler() instanceof AfterVisitor && visitorBinding.getResourceConfig().getSelectorPath() instanceof IndexedSelectorPath && ((IndexedSelectorPath)visitorBinding.getResourceConfig().getSelectorPath()).getTargetSelectorStep() instanceof ElementSelectorStep ? ((ElementSelectorStep)((IndexedSelectorPath)visitorBinding.getResourceConfig().getSelectorPath()).getTargetSelectorStep()).accessesText() : false)) : false;
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.intercept(this.visitBeforeInvocation, element, executionContext);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.isTextConsumer) {
            TextAccumulatorMemento textAccumulatorMemento = new TextAccumulatorMemento(new NodeFragment(element));
            executionContext.getMementoCaretaker().restore(textAccumulatorMemento);
            executionContext.getMementoCaretaker().capture(textAccumulatorMemento);
            element.setTextContent(textAccumulatorMemento.getText());
        }
        this.intercept(this.visitAfterInvocation, element, executionContext);
        if (this.isTextConsumer) {
            element.setTextContent("");
        }
    }

    @Override
    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) throws SmooksException {
        NodeFragment parentNodeFragment;
        if (this.isTextConsumer && (parentNodeFragment = new NodeFragment(characterData.getParentNode())).reserve(Long.parseLong(parentNodeFragment.getId()), this)) {
            executionContext.getMementoCaretaker().stash(new TextAccumulatorMemento(parentNodeFragment), textAccumulatorMemento -> textAccumulatorMemento.accumulateText(characterData.getTextContent()));
        }
        this.intercept(this.visitChildTextInvocation, characterData, executionContext);
    }

    @Override
    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
        this.intercept(this.visitChildElementInvocation, childElement, executionContext);
    }
}

