/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.bridge;

import org.smooks.api.ExecutionContext;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.interceptor.AbstractInterceptorVisitor;
import org.smooks.engine.delivery.sax.ng.bridge.Bridge;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeInterceptor
extends AbstractInterceptorVisitor
implements ElementVisitor {
    protected boolean doVisit(Node node, String currentVisit, ExecutionContext executionContext) {
        if (((Element)node).getAttribute("visit").equals(currentVisit)) {
            Node sourceNode = (Node)executionContext.get(TypedKey.of(((Element)node).getAttribute("source")));
            if (sourceNode instanceof CharacterData) {
                return new NodeFragment(sourceNode.getParentNode()).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext);
            }
            return new NodeFragment(sourceNode).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext);
        }
        return false;
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) {
        if (Bridge.isBridge(element)) {
            if (this.doVisit(element, "visitBefore", executionContext)) {
                Object source = executionContext.get(TypedKey.of(element.getAttribute("source")));
                this.intercept(this.visitBeforeInvocation, source, executionContext);
            }
        } else if (new NodeFragment(element).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext)) {
            this.intercept(this.visitBeforeInvocation, element, executionContext);
        }
    }

    @Override
    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        if (new NodeFragment(characterData.getParentNode()).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext)) {
            this.intercept(this.visitChildTextInvocation, characterData, executionContext);
        }
    }

    @Override
    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
        this.intercept(this.visitChildElementInvocation, childElement, executionContext);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) {
        if (Bridge.isBridge(element)) {
            if (this.doVisit(element, "visitChildText", executionContext) || this.doVisit(element, "visitAfter", executionContext)) {
                Object source = executionContext.get(TypedKey.of(element.getAttribute("source")));
                if (element.getAttribute("visit").equals("visitChildText")) {
                    this.visitChildText((CharacterData)source, executionContext);
                } else {
                    this.intercept(this.visitAfterInvocation, source, executionContext);
                }
            }
        } else if (new NodeFragment(element).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext)) {
            this.intercept(this.visitAfterInvocation, element, executionContext);
        }
    }
}

