/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigFactory;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultResourceConfigFactory
implements ResourceConfigFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceConfigFactory.class);

    @Override
    public ResourceConfig create(String defaultProfile, Element element) {
        String selector = DomUtils.getAttributeValue(element, "selector");
        String targetProfile = DomUtils.getAttributeValue(element, "target-profile");
        Element resourceElement = DomUtils.getElementByTagName(element, "resource");
        String resource = resourceElement != null ? DomUtils.getAllText(resourceElement, true) : null;
        DefaultResourceConfig resourceConfig = new DefaultResourceConfig(selector, this.getNamespaces(element), targetProfile != null ? targetProfile : defaultProfile, resource);
        if (resourceElement != null) {
            resourceConfig.setResourceType(DomUtils.getAttributeValue(resourceElement, "type"));
        }
        if (resource == null) {
            LOGGER.debug("Resource 'null' for resource config: " + resourceConfig + ". This is not invalid!");
        }
        return resourceConfig;
    }

    private Properties getNamespaces(Element element) {
        Properties namespaces = new Properties();
        if (element.getParentNode() != null && element.getParentNode().getAttributes() != null) {
            for (int i = 0; i < element.getParentNode().getAttributes().getLength(); ++i) {
                Node node = element.getParentNode().getAttributes().item(i);
                String prefix = node.getNodeName();
                if (!prefix.startsWith("xmlns") || prefix.indexOf(":") <= 0) continue;
                prefix = prefix.substring(prefix.indexOf(":") + 1);
                namespaces.put(prefix, node.getNodeValue());
            }
        }
        return namespaces;
    }
}

