/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.io.IOException;
import java.io.InputStream;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.ContainerResourceLocator;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.config.ResourceConfigSeqFactory;
import org.smooks.api.resource.config.loader.ResourceConfigLoader;

public class SystemResourceConfigSeqFactory
implements ResourceConfigSeqFactory {
    private final ClassLoader classLoader;
    private final String resourceFile;
    private final ContainerResourceLocator resourceLocator;
    private final ResourceConfigLoader resourceConfigLoader;

    public SystemResourceConfigSeqFactory(String resourceFile, ClassLoader classLoader, ContainerResourceLocator resourceLocator, ResourceConfigLoader resourceConfigLoader) {
        this.classLoader = classLoader;
        this.resourceFile = resourceFile;
        this.resourceLocator = resourceLocator;
        this.resourceConfigLoader = resourceConfigLoader;
    }

    @Override
    public ResourceConfigSeq create() {
        InputStream resource;
        try {
            resource = this.resourceLocator.getResource(this.resourceFile);
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
        if (resource == null) {
            throw new IllegalStateException("Failed to load " + this.resourceFile);
        }
        try {
            ResourceConfigSeq resourceConfigSeq = this.resourceConfigLoader.load(resource, this.resourceFile, this.classLoader);
            for (int i = 0; i < resourceConfigSeq.size(); ++i) {
                resourceConfigSeq.get(i).setSystem(true);
            }
            resourceConfigSeq.setSystem(true);
            return resourceConfigSeq;
        }
        catch (Exception e) {
            throw new SmooksException("Error processing resource file '" + this.resourceFile + "'.", e);
        }
    }
}

