/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicated;
import org.jaxen.expr.XPathExpr;
import org.jaxen.expr.XPathFactory;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.SimpleSelectorPath;
import org.smooks.engine.resource.config.xpath.predicate.AttributePredicate;
import org.smooks.engine.resource.config.xpath.predicate.DefaultPredicateEvaluator;
import org.smooks.engine.resource.config.xpath.predicate.PositionPredicateEvaluator;
import org.smooks.engine.resource.config.xpath.step.AllSelectorStep;
import org.smooks.engine.resource.config.xpath.step.AttributeSelectorStep;
import org.smooks.engine.resource.config.xpath.step.DocumentSelectorStep;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;

public class SelectorPathJaxenHandler
extends JaxenHandler {
    private final String selector;
    private final Properties namespaces;
    private SelectorPath selectorPath;
    private boolean isTextNode = false;
    private boolean isPredicate = false;

    public SelectorPathJaxenHandler(String selector, Properties namespaces) {
        this.selector = selector;
        this.namespaces = namespaces;
    }

    @Override
    public void setXPathFactory(XPathFactory xpathFactory) {
        super.setXPathFactory(xpathFactory);
    }

    @Override
    public XPathFactory getXPathFactory() {
        return super.getXPathFactory();
    }

    @Override
    public XPathExpr getXPathExpr() {
        return super.getXPathExpr();
    }

    @Override
    public XPathExpr getXPathExpr(boolean shouldSimplify) {
        return super.getXPathExpr(shouldSimplify);
    }

    @Override
    public void startXPath() {
        super.startXPath();
    }

    @Override
    public void endXPath() throws JaxenException {
        super.endXPath();
    }

    @Override
    public void startPathExpr() {
        super.startPathExpr();
    }

    @Override
    public void endPathExpr() throws JaxenException {
        super.endPathExpr();
    }

    @Override
    public void startAbsoluteLocationPath() throws JaxenException {
        this.selectorPath = new IndexedSelectorPath(this.selector);
        this.selectorPath.add(new DocumentSelectorStep());
        super.startAbsoluteLocationPath();
    }

    @Override
    public void endAbsoluteLocationPath() throws JaxenException {
        super.endAbsoluteLocationPath();
    }

    @Override
    public void startRelativeLocationPath() throws JaxenException {
        if (this.selectorPath == null) {
            this.selectorPath = new IndexedSelectorPath(this.selector);
        }
        super.startRelativeLocationPath();
    }

    @Override
    public void endRelativeLocationPath() throws JaxenException {
        super.endRelativeLocationPath();
    }

    @Override
    protected void endLocationPath() throws JaxenException {
        super.endLocationPath();
    }

    @Override
    protected void addSteps(LocationPath locationPath, Iterator stepIter) {
        super.addSteps(locationPath, stepIter);
    }

    @Override
    public void startNameStep(int axis, String prefix, String localName) throws JaxenException {
        if (axis == 9) {
            if (this.isPredicate) {
                ((SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1)).getPredicates().add(new AttributePredicate(this.namespaces.getProperty(prefix), localName));
            } else {
                this.selectorPath.add(new AttributeSelectorStep(this.namespaces.getProperty(prefix), localName, prefix));
            }
        } else if (!(this.selectorPath instanceof IndexedSelectorPath && localName.equals("*") && ((IndexedSelectorPath)this.selectorPath).getTargetSelectorStep() instanceof DocumentSelectorStep || this.isPredicate)) {
            this.selectorPath.add(new ElementSelectorStep(this.namespaces.getProperty(prefix), localName, prefix));
        }
        super.startNameStep(axis, prefix, localName);
    }

    @Override
    public void endNameStep() {
        super.endNameStep();
    }

    @Override
    public void startTextNodeStep(int axis) throws JaxenException {
        this.isTextNode = true;
        super.startTextNodeStep(axis);
    }

    @Override
    public void endTextNodeStep() {
        super.endTextNodeStep();
    }

    @Override
    public void startCommentNodeStep(int axis) throws JaxenException {
        super.startCommentNodeStep(axis);
    }

    @Override
    public void endCommentNodeStep() {
        super.endCommentNodeStep();
    }

    @Override
    public void startAllNodeStep(int axis) throws JaxenException {
        this.selectorPath.add(new AllSelectorStep());
        super.startAllNodeStep(axis);
    }

    @Override
    public void endAllNodeStep() {
        super.endAllNodeStep();
    }

    @Override
    public void startProcessingInstructionNodeStep(int axis, String name) throws JaxenException {
        super.startProcessingInstructionNodeStep(axis, name);
    }

    @Override
    public void endProcessingInstructionNodeStep() {
        super.endProcessingInstructionNodeStep();
    }

    @Override
    protected void endStep() {
        super.endStep();
    }

    @Override
    public void startPredicate() {
        this.isPredicate = true;
        super.startPredicate();
    }

    @Override
    public void endPredicate() throws JaxenException {
        Expr expr = (Expr)this.peekFrame().getFirst();
        SelectorStep currentSelectorStep = (SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1);
        if (expr instanceof PathExpr) {
            if (((PathExpr)expr).getFilterExpr() != null) {
                if (((FilterExpr)((PathExpr)expr).getFilterExpr()).getExpr() instanceof NumberExpr) {
                    ((SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1)).getPredicates().add(new PositionPredicateEvaluator(expr, ((ElementSelectorStep)currentSelectorStep).getQName().getLocalPart(), ((ElementSelectorStep)currentSelectorStep).getQName().getNamespaceURI()));
                } else {
                    ((SelectorStep)this.selectorPath.get(this.selectorPath.size() - 1)).getPredicates().add(new DefaultPredicateEvaluator(expr));
                }
            }
        } else if (expr instanceof BinaryExpr && this.isTextNode) {
            ((ElementSelectorStep)currentSelectorStep).setAccessesText(true);
            currentSelectorStep.getPredicates().add(new DefaultPredicateEvaluator(expr));
        }
        this.isTextNode = false;
        this.isPredicate = false;
        super.endPredicate();
    }

    @Override
    public void startFilterExpr() {
        super.startFilterExpr();
    }

    @Override
    public void endFilterExpr() throws JaxenException {
        super.endFilterExpr();
    }

    @Override
    protected void addPredicates(Predicated obj, Iterator predIter) {
        super.addPredicates(obj, predIter);
    }

    @Override
    protected void returnExpr() {
        super.returnExpr();
    }

    @Override
    public void startOrExpr() {
        super.startOrExpr();
    }

    @Override
    public void endOrExpr(boolean create) throws JaxenException {
        super.endOrExpr(create);
    }

    @Override
    public void startAndExpr() {
        super.startAndExpr();
    }

    @Override
    public void endAndExpr(boolean create) throws JaxenException {
        super.endAndExpr(create);
    }

    @Override
    public void startEqualityExpr() {
        super.startEqualityExpr();
    }

    @Override
    public void endEqualityExpr(int operator) throws JaxenException {
        super.endEqualityExpr(operator);
    }

    @Override
    public void startRelationalExpr() {
        super.startRelationalExpr();
    }

    @Override
    public void endRelationalExpr(int operator) throws JaxenException {
        super.endRelationalExpr(operator);
    }

    @Override
    public void startAdditiveExpr() {
        super.startAdditiveExpr();
    }

    @Override
    public void endAdditiveExpr(int operator) throws JaxenException {
        super.endAdditiveExpr(operator);
    }

    @Override
    public void startMultiplicativeExpr() {
        super.startMultiplicativeExpr();
    }

    @Override
    public void endMultiplicativeExpr(int operator) throws JaxenException {
        super.endMultiplicativeExpr(operator);
    }

    @Override
    public void startUnaryExpr() {
        super.startUnaryExpr();
    }

    @Override
    public void endUnaryExpr(int operator) throws JaxenException {
        super.endUnaryExpr(operator);
    }

    @Override
    public void startUnionExpr() {
        super.startUnionExpr();
    }

    @Override
    public void endUnionExpr(boolean create) throws JaxenException {
        super.endUnionExpr(create);
    }

    @Override
    public void number(int number) throws JaxenException {
        super.number(number);
    }

    @Override
    public void number(double number) throws JaxenException {
        super.number(number);
    }

    @Override
    public void literal(String literal) throws JaxenException {
        super.literal(literal);
    }

    @Override
    public void variableReference(String prefix, String variableName) throws JaxenException {
        super.variableReference(prefix, variableName);
    }

    @Override
    public void startFunction(String prefix, String functionName) throws JaxenException {
        if (this.selectorPath == null) {
            this.selectorPath = new SimpleSelectorPath(this.selector);
        }
        super.startFunction(prefix, functionName);
    }

    @Override
    public void endFunction() {
        super.endFunction();
    }

    @Override
    protected void addParameters(FunctionCallExpr function, Iterator paramIter) {
        super.addParameters(function, paramIter);
    }

    @Override
    protected int stackSize() {
        return super.stackSize();
    }

    @Override
    protected void push(Object obj) {
        super.push(obj);
    }

    @Override
    protected Object pop() {
        return super.pop();
    }

    @Override
    protected boolean canPop() {
        return super.canPop();
    }

    @Override
    protected void pushFrame() {
        super.pushFrame();
    }

    @Override
    protected LinkedList popFrame() {
        return super.popFrame();
    }

    @Override
    protected LinkedList peekFrame() {
        return super.peekFrame();
    }

    public SelectorPath getSelectorPath() {
        return this.selectorPath;
    }

    public String getSelector() {
        return this.selector;
    }
}

