/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks.converter;

import java.io.InputStream;
import javax.xml.transform.Source;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.smooks.converter.SourceConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.smooks.io.payload.JavaResult;
import org.smooks.io.payload.JavaSource;
import org.smooks.io.payload.JavaSourceWithoutEventStream;

@DeferredContextBinding
public final class SourceConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SourceConverterLoader.addTypeConverter(registry, Source.class, InputStream.class, false, (type, exchange, value) -> SourceConverter.toStreamSource((InputStream)value));
        SourceConverterLoader.addTypeConverter(registry, Source.class, WrappedFile.class, true, (type, exchange, value) -> SourceConverter.toStreamSource((WrappedFile)value, exchange));
        SourceConverterLoader.addTypeConverter(registry, JavaSource.class, Object.class, false, (type, exchange, value) -> SourceConverter.toJavaSource(value));
        SourceConverterLoader.addTypeConverter(registry, JavaSource.class, JavaResult.class, false, (type, exchange, value) -> SourceConverter.toJavaSource((JavaResult)value));
        SourceConverterLoader.addTypeConverter(registry, JavaSourceWithoutEventStream.class, Object.class, false, (type, exchange, value) -> SourceConverter.toJavaSourceWithoutEventStream(value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }
}

