/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.bean.context;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.smooks.api.ExecutionContext;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.engine.bean.context.StandaloneBeanContext;
import org.smooks.io.payload.FilterResult;
import org.smooks.io.payload.FilterSource;
import org.smooks.io.payload.JavaResult;
import org.smooks.io.payload.JavaSource;

public class StandaloneBeanContextFactory {
    public static StandaloneBeanContext create(ExecutionContext executionContext) {
        BeanIdStore beanIdStore = executionContext.getApplicationContext().getBeanIdStore();
        Map<String, Object> beanMap = StandaloneBeanContextFactory.createBeanMap(executionContext, beanIdStore);
        StandaloneBeanContext beanContext = new StandaloneBeanContext(executionContext, beanIdStore, beanMap);
        return beanContext;
    }

    private static Map<String, Object> createBeanMap(ExecutionContext executionContext, BeanIdStore beanIdStore) {
        JavaSource javaSource;
        Map<String, Object> sourceBeans;
        Result result = FilterResult.getResult(executionContext, JavaResult.class);
        Source source = FilterSource.getSource(executionContext);
        Map<String, Object> beanMap = null;
        if (result != null) {
            JavaResult javaResult = (JavaResult)result;
            beanMap = javaResult.getResultMap();
        }
        if (source instanceof JavaSource && (sourceBeans = (javaSource = (JavaSource)source).getBeans()) != null) {
            if (beanMap != null) {
                beanMap.putAll(sourceBeans);
            } else {
                beanMap = sourceBeans;
            }
        }
        if (beanMap == null) {
            beanMap = new HashMap<String, Object>();
        } else {
            for (String beanId : beanMap.keySet()) {
                if (beanIdStore.containsBeanId(beanId)) continue;
                beanIdStore.register(beanId);
            }
        }
        return beanMap;
    }
}

