/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

public class StringToBigIntegerConverterFactory
implements TypeConverterFactory<String, BigInteger>,
Configurable {
    private Properties properties = new Properties();

    @Override
    public TypeConverter<String, BigInteger> createTypeConverter() {
        NumberTypeConverter<String, BigInteger> numberTypeConverter = new NumberTypeConverter<String, BigInteger>(){

            @Override
            protected BigInteger doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (number instanceof BigInteger) {
                            return (BigInteger)number;
                        }
                        if (number instanceof BigDecimal) {
                            return ((BigDecimal)number).toBigInteger();
                        }
                        return new BigInteger(String.valueOf(number.intValue()));
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode BigInteger value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", e);
                    }
                }
                try {
                    return new BigInteger(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode BigInteger value '" + value + "'.", e);
                }
            }
        };
        numberTypeConverter.setConfiguration(this.properties);
        return numberTypeConverter;
    }

    @Override
    public TypeConverterDescriptor<Class<String>, Class<BigInteger>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<BigInteger>>(String.class, BigInteger.class);
    }

    @Override
    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    @Override
    public Properties getConfiguration() {
        return this.properties;
    }
}

