/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import org.smooks.engine.converter.DateLocaleAwareTypeConverter;

public abstract class StringToDateLocaleAwareConverter<T>
extends DateLocaleAwareTypeConverter<String, T> {
    @Override
    public T convert(String value) {
        TemporalAccessor temporalAccessor = this.dateTimeFormatter.parse(value.trim());
        Date date = temporalAccessor.query(TemporalQueries.localDate()) != null && temporalAccessor.query(TemporalQueries.localTime()) != null && temporalAccessor.query(TemporalQueries.zoneId()) != null ? Date.from(LocalDateTime.from(temporalAccessor).atZone(temporalAccessor.query(TemporalQueries.zoneId())).toInstant()) : (temporalAccessor.query(TemporalQueries.localDate()) != null && temporalAccessor.query(TemporalQueries.localTime()) != null ? Date.from(LocalDateTime.from(temporalAccessor).atZone(this.zoneId).toInstant()) : (temporalAccessor.query(TemporalQueries.localDate()) != null ? Date.from(LocalDate.from(temporalAccessor).atStartOfDay(this.zoneId).toInstant()) : (temporalAccessor.query(TemporalQueries.localTime()) != null && temporalAccessor.query(TemporalQueries.zoneId()) != null ? Date.from(LocalTime.from(temporalAccessor).atDate(Instant.ofEpochMilli(0L).atZone(temporalAccessor.query(TemporalQueries.zoneId())).toLocalDate()).atZone(temporalAccessor.query(TemporalQueries.zoneId())).toInstant()) : (temporalAccessor.query(TemporalQueries.localTime()) != null ? Date.from(LocalTime.from(temporalAccessor).atDate(Instant.ofEpochMilli(0L).atZone(this.zoneId).toLocalDate()).atZone(this.zoneId).toInstant()) : null))));
        return this.doConvert(date);
    }

    protected abstract T doConvert(Date var1);
}

